use strict;
use warnings;
use ExtUtils::MakeMaker qw( WriteMakefile prompt );

my %config = (
    NAME          => 'MD5::Solve',
    AUTHOR        => 'Emilia Anna Perl-Podegaczka <emmils@example.com>',
    VERSION_FROM  => 'lib/MD5/Solve.pm',
    ABSTRACT_FROM => 'lib/MD5/Solve.pm',
    PREREQ_PM     => { 'Test::More' => 0, },
    dist          => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'MD5-Solve-*' },
);

my @patterns = qw( t/*.t );

print "==> Uruchomienie rozszerzonego zestawu testw moe zabra tygodnie lub lata! <==\n";
my $answer = prompt( 'Czy chcesz uruchomi rozszerzony zestaw testw?', 'no' );

if ( $answer =~ m/^y/i ) 
{
    print "Uruchamiam rozszerzone testy.\n";
    push @patterns, 't/long/*.t';
}
else 
{
    print "Pomijam rozszerzone testy.\n";
}

$config{test} = { TESTS => join ' ', map { glob } @patterns };

WriteMakefile(%config);
