<?php
/**
 * Korzystamy z pakietu Services_Amazon 
 */
require_once 'Services/AmazonECS4.php';


// Nasz identyfikator subskrypcji 
$subscriptionId = '0DDMH995CMFWSXK3A6G2';

// Nasz identyfikator partnera Amazon 
$accociateId = 'schstnet-20';

// tworzymy nowego klinta przesyaj
// identyfikatory subskrypcji i partnera Amazon
$amazon  = new Services_AmazonECS4($subscriptionId, $accociateId);
$amazon->setLocale('US');

$options = array();
$options['Publisher'] = 'Packt Publishing';
$options['Sort'] = 'salesrank';
$options['ResponseGroup'] = 'ItemIds,ItemAttributes,Images';
$result = $amazon->ItemSearch('Books', $options);

if (PEAR::isError($result)) {
	print "Wystpi bd<br/>\n";
	print $result->getMessage() . "<br/>\n";
	exit();
}

foreach ($result['Item'] as $book) {
    print '<div style="margin-bottom:20px; clear:both;">';
    printf('<a href="%s"><img src="%s" title="%s" style="float:left; padding-right: 10px; border: 0px;"/></a>',
            $book['DetailPageURL'],
            $book['SmallImage']['URL'],
            $book['ItemAttributes']['Title']);
    printf('<h3>%s</h3>', $book['ItemAttributes']['Title']);
    if (is_array($book['ItemAttributes']['Author'])) {
    	$book['ItemAttributes']['Author'] = implode(', ', $book['ItemAttributes']['Author']);
    }
    printf('<p>%s<br/>%s</p>',
            $book['ItemAttributes']['Author'],
            $book['ItemAttributes']['ListPrice']['FormattedPrice']);
    print '</div>';
}
?>