<?php
/**
 * Tworzy dla nas dokument XML
 */
require_once 'XML/Serializer.php';

/**
 * Zawiera logik biznesow
 */
require_once 'REST-Server-003.php';

/**
 * Oglnego zastosowania serwer REST 
 */
class REST_Server
{
   /**
    * obiekt, ktry zawiera logik biznesow 
    */
   private $handler;

   /**
    * nazwa parametru dania, ktry zawiera nazw metody 
    */
   private $methodVar;

   /**
    * Tworzymy nowy serwer REST 
    *
    * @param object Obiekt zawierajcy logik biznesow
    * @param string Nazwa zmiennej dania
    * zawierajcej wywoanie metody
    */
    public function __construct($handler, $methodVar = 'm')
    {
       $this->handler = $handler;
       $this->methodVar = $methodVar;
    }
}

/**
 * Uruchamiamy usug REST 
 */
public function service()
{
   // Pniej wylemy XML 
   header('Content-Type: text/xml');

   // pobieramy nazw metody, ktra powinna zosta przywoana
   if (!isset($_GET[$this->methodVar]))
   {
      $this->sendFault(1, 'Nie dano adnej metody.');
   }
   $method = $_GET[$this->methodVar];

   // Sprawdzamy, czy metoda istnieje
   $reflect = new ReflectionObject($this->handler);
   try
   {
      $method = $reflect->getMethod($method);
   }
      catch (ReflectionException $e)
   {
   $this->sendFault(2, $e->getMessage());
   }

   // sprawdzamy, czy zostay przesane
   // wszystkie parametry metody
   $parameters = $method->getParameters();
   $values = array();
   foreach ($parameters as $parameter)
   {
      $name = $parameter->getName();
      if (isset($_GET[$name]))
         {
              $values[] = $_GET[$name];
              continue;
         }
      if ($parameter->isDefaultValueAvailable())
         {
            $values[] = $parameter->getDefaultValue();
            continue;
         }
     $this->sendFault(3, 'Missing parameter ' . $name . '.');
   }

   // Przywoujemy sama metod i wysyamy wyniki klientowi
   try
   {
      // Rozwizanie to bdzie dziaa poczwszy od PHP 5.1:
      // $method->invokeArgs($this->handler, $values);
     $result = call_user_func_array(
        array($this->handler, $method->getName()), $values);
      $this->sendResult($method->getName(), $result);
   }
   catch (Exception $e)
   {
      $this->sendFault($e->getCode(), $e->getMessage());
   }
}

/**
 * Wysyamy wynik do klienta w postaci kodu XML 
 *
 * @param string, acuch nazwa przywoywanej metody
 * @param rnie, wyniki korzystania z logiki biznesowej
 */
protected function sendResult($methodName, $result)
{
   $matches = array();
   if (preg_match('/^get([a-z]+)s$/i', $methodName, $matches))
   {
      $defaultTag = strtolower($matches[1]);
   }
   else
   {
      $defaultTag = 'item';
   }

   $serializer = new XML_Serializer();
   $serializer->setOption(XML_SERIALIZER_OPTION_ROOT_NAME,
                          $methodName.'Result');
   $serializer->setOption(XML_SERIALIZER_OPTION_DEFAULT_TAG,
                          $defaultTag);
   $serializer->serialize($result);
   echo $serializer->getSerializedData();
   exit();
}
 
/**
 * Sygnalizujemy bd
 *
 * @param integer, liczba cakowita, kod bdu
 * @param string, acuch, komunikat o bdzie
 */
protected function sendFault($faultCode, $faultString)
{
   $serializer = new XML_Serializer();
   $serializer->setOption(XML_SERIALIZER_OPTION_ROOT_NAME,
                                                       'fault');
   $serializer->serialize(array('faultCode' => $faultCode,
                                'faultString' => $faultString));
   echo $serializer->getSerializedData();
   exit();
}

}
$handler = new RecordLabel();
$service = new REST_Server($handler);
$service->service();
?>