<?php
/**
 * Doczamy waciw logik biznesow
 */
require_once 'XML_RPC-Server-001.php';

/**
 * Doczamy klas serwera XML-RPC 
 */
require_once 'XML/RPC/Server.php';

/**
 * Obudowanie XML-RPC dla tej logiki biznesowej
 *
 * @access public
 * @param XML_RPC_Message Komunikat wysyany przez klienta
 * @return XML_RPC_Response Kodowana odpowied serwera
 */
function getRecordsService($args)
{
    $artist  = $args->getParam(0)->scalarval();
    $records = getRecords($artist);
    if ($records === false) {
        $response = new XML_RPC_Response(0, 50, 'Artysty "'.$artist.'" nie ma w naszej bazie danych.');
    } else {
       	$val = XML_RPC_encode($records);
       	$response = new XML_RPC_Response($val);
    }
   	return $response;
}

// mapujemy nazwy metod XML-RPC na funkcje PHP 
$map = array(
        'label.getRecords' => array(
                         'function'  => 'getRecordsService',
                         'signature' =>
                                    array(
                                        array('array', 'string'),
                                    ),
                         'docstring' => 'Pobierz wszystkie albumy danego artysty.'
                        )
       );
       
// tworzymy i uruchamiamy usug
$server = new XML_RPC_Server($map);
?>