<?php
error_reporting(E_ALL);
setlocale(LC_ALL, 'en_US');

require_once 'Calendar/Month/Weekdays.php';
require_once 'Calendar/Util/Uri.php';

// pobieramy informacje o dacie z dania lub uywamy biecej daty
$y = isset($_GET['year']) ? $_GET['year'] : date('Y');
$m = isset($_GET['month']) ? $_GET['month'] : date('m');

$month = new Calendar_Month_Weekdays($y, $m, $firstDay = 1);
$month->build();

// Lokalizowany tekst dla nagwka kalendarza
$header = strftime('%B %Y', $month->thisMonth('timestamp'));

// Obiekt Calendar_URI_Util dla generowania czy nawigacyjnych
$uriUtil = new Calendar_Util_Uri('year', 'month');
$nextM = $uriUtil->next($month, 'month');
$prevM = $uriUtil->prev($month, 'month');

echo <<<EOQ
<table width="250">
   <!-- nagwek kalendarza -->
   <tr>
      <td align="left"><a href="{
                         $_SERVER['PHP_SELF']}?$prevM">&lt;</a></td>
      <td colspan="5" align="center">$header</td>
      <td align="right"><a href="{
                         $_SERVER['PHP_SELF']}?$nextM">&gt;</td>
   </tr>
   <tr>
          <td align="center">Pon</td>
          <td align="center">Wto</td>
          <td align="center">ro</td>
          <td align="center">Czw</td>
          <td align="center">Pi</td>
          <td align="center">Sob</td>
          <td align="center">Nie</td>
      </tr>
   <!-- dane kalendarza -->
   <tr>
EOQ;

// przegldamy zbudowane dni tygodnia i wywietlamy je
while ($day = $month->fetch()) {
    if ($day->isFirst()) {
        echo '<tr>';
    }

    if ($day->isEmpty()) {
        echo '<td><div>&nbsp;</div></td>';
    } else {
        echo '<td align="center"><div>'.$day->thisDay().'</div></td>';
    }

    if ($day->isLast()) {
        echo "</tr>\n";
    }
}
echo '</table>';

?>
