<?php
/**
 * Korzystamy z pakietu HTTP_Request, by utworzy poczenie HTTP 
 */
 require_once 'HTTP/Request.php';

/**
 * Pakiet XML_Unserializer zanalizuje dla nas kod XML
 */
require_once 'XML/Unserializer.php';


// Tworzymy nowy obiekt dania bazujcy na adresie URL interfejsu API 
$request = new HTTP_Request('http://api.search.yahoo.com/WebSearchService/V1/webSearch');

// Dodajemy parametry dania
$request->addQueryString('appid', 'packt-pear-book');
$request->addQueryString('query', 'PEAR');

// Wysyamy danie HTTP i przechwytujemy odpowied
$request->sendRequest();

// Sprawdzamy, czy danie zakoczyo si powodzeniem
if ($request->getResponseCode() !== 200) {
    die("HTTP request failed.");
}

$us = new XML_Unserializer();
// pobieramy dane z atrybutw
$us->setOption(XML_UNSERIALIZER_OPTION_ATTRIBUTES_PARSE, true);

// tworzymy tablice
$us->setOption(XML_UNSERIALIZER_OPTION_COMPLEXTYPE, 'array');

// dekodujemy UTF-8 na ISO-8859-1
$us->setOption(XML_UNSERIALIZER_OPTION_ENCODING_SOURCE, 'UTF-8');
$us->setOption(XML_UNSERIALIZER_OPTION_ENCODING_TARGET, 'ISO-8859-1');

// Nawet gdy zwracany jest tylko jeden wynik, nadal tworzymy tablic indeksowan 
$us->setOption(XML_UNSERIALIZER_OPTION_FORCE_ENUM, array('Result'));

// analizujemy dokumnt XML 
$result = $us->unserialize($request->getResponseBody());

// sprawdzamy, czy pojawi si bd
if (PEAR::isError($result)) {
	echo "Pojawi si bd: ";
	echo $result->getMessage();
}

// pobieramy wyniki
$result = $us->getUnserializedData();

// przegldamy wyniki w ptli
foreach ($result['Result'] as $item) {
    printf("%s\n", $item['Title']);
    printf("%s\n\n", $item['Summary']);
}
?>