<?php
/**
 * Oferuje rne metody umoliwiajce siganie
 * do danych albumw wydanych przez studio.
 */
class RecordLabel
{
   /**
    * Wszystkie nasze albumy.
    *
    * W prawdziwej aplikacji pobieralibymy 
    * dane z bazy danych.
    */
    private $records = array(
            'Elvis Presley' => array(
                                'That\'s All Right (Mama) & Blue Moon Of Kentucky',
                                'Good Rockin\' Tonight',
                               ),
            'Carl Perkins'  => array(
                                'Gone, Gone, Gone'
                               )
           );

   /**
    * pobieramy wszystkie albumy danego artysty
    *
    * @param string
    * @return string[]
    */
    public function getRecords($artist)
    {
        if (isset($this->records[$artist])) {
            $result = $this->records[$artist];
            return $result;
        } else {
            throw new SoapFault(50, 'Artysty "'.$artist.'" nie ma w naszej bazie danych.');
        }
    }
 
   /**
    * Pobieramy wszystkich artystw, z ktrymi mamy kontrakty
    *
    * @return string[]
    */
    public function getArtists()
    {
        return array_keys($this->records);
    }

/**
 * Pobieramy wszystkie albumy Elvisa.
 *
 * @return string[]
 * @deprecated Zamiast niej naley uywa getRecords() 
 */

    public function getRecordsByElvis()
    {
        return $this->getRecords('Elvis Presley');
    }

/**
 * Pomocnicza metoda, ktra nie bedzie widziana przez usug WWW.
 *
 * @webservice.hidden
 */
public function doSomeHelperStuff()
{
   // bez kodu, ta metoda to tylko atrapa 
}
}
?>