<?php
// zaczamy klas bazow
require_once 'XML/Parser.php';

// tworzymy klas rozszerzajc klas XML_Parser
class ConfigReader extends XML_Parser

{
   /**
   * zajmujemy si znacznikami otwierajcymi
   *
   * @param zasb parsera
   * @param acuch z nazw znacznika
   * @param tablica atrybutw
   */
   public function startHandler($parser, $name, $attribs)
   {
      echo "Znaleziono element pocztkowy $name\n";
   }
   /**
   * zajmujemy si danymi znakowymi
   *
   * @param zasb parsera
   * @param acuch z danymi znakowymi
   */
   public function cdataHandler($parser, $cData)
   {
      $cData = trim($cData);
      if ($cData === '') {
          return;
      }
      echo "...data '$cData' found\n";
   }
   /**
   * obsugujemy znaczniki zamykajce
   *
   * @param zasb parsera
   * @param acuch z nazw znacznika
   */
   public function endHandler($parser, $name)
   {
      echo "Znaleziono element kocowy $name\n";
   }
}

// Tworzymy now instancj klasy
$config = new ConfigReader();

// podajemy nazw analizowanego pliku
$config->setInputFile('config.xml');

// analizujemy plik i przechwytujemy bdy
$result = $config->parse();
if (PEAR::isError($result)) {
   echo 'Analiza zakoczona niepowodzeniem: ' . $result->getMessage();
}
$config->free();

?>