 #include <lcthw/tstree.h>
 #include <lcthw/bstrlib.h>

 TSTree *add_route_data(TSTree * routes, bstring line)
 {
     struct bstrList *data = bsplit(line, ' ');
     check(data->qty == 2, "Wiersz '%s' nie zawiera 2 kolumn.",
         bdata(line));

     routes = TSTree_insert(routes,
         bdata(data->entry[0]),
         blength(data->entry[0]),
         bstrcpy(data->entry[1]));

     bstrListDestroy(data);

     return routes;

 error:
     return NULL;
 }

 TSTree *load_routes(const char *file)
 {
     TSTree *routes = NULL;
     bstring line = NULL;
     FILE *routes_map = NULL;

     routes_map = fopen(file, "r");
     check(routes_map != NULL, "Nie udało się otworzyć tras: %s", file);

     while ((line = bgets((bNgetc) fgetc, routes_map, '\n')) != NULL) {
         check(btrimws(line) == BSTR_OK, "Nie udało się skrócić wiersza.");
         routes = add_route_data(routes, line);
         check(routes != NULL, "Nie udało się dodać trasy.");
         bdestroy(line);
     }

     fclose(routes_map);
     return routes;

 error:
     if (routes_map) fclose(routes_map);
     if (line) bdestroy(line);

     return NULL;
 }

 bstring match_url(TSTree * routes, bstring url)
 {
     bstring route = TSTree_search(routes, bdata(url), blength(url));

     if (route == NULL) {
         printf("Brak dokładnego dopasowania, próbuję prefiks.\n");
         route = TSTree_search_prefix(routes, bdata(url), blength(url));
     }

     return route;
 }

 bstring read_line(const char *prompt)
 {
     printf("%s", prompt);

     bstring result = bgets((bNgetc) fgetc, stdin, '\n');
     check_debug(result != NULL, "Zamknięte standardowe wejście.");

     check(btrimws(result) == BSTR_OK, "Nie udało się skrócić.");

     return result;

 error:
     return NULL;
 }

 void bdestroy_cb(void *value, void *ignored)
 {
     (void)ignored;
     bdestroy((bstring) value);
 }

 void destroy_routes(TSTree * routesP
 {
     TSTree_traverse(routes, bdestroy_cb, NULL);
     TSTree_destroy(routes);
 }

 int main(int argc, char *argv[])
 {
     bstring url = NULL;
     bstring route = NULL;
     TSTree *routes = NULL;

     check(argc == 2, "UŻYCIE: urlor <urlfile>");

     routes = load_routes(argv[1]);
     check(routes != NULL, "Plik tras zawiera błąd.");

     while (1) {
         url = read_line("URL> ");
         check_debug(url != NULL, "do widzenia.");

         route = match_url(routes, url);

         if (route) {
             printf("DOPASOWANIE: %s == %s\n", bdata(url), bdata(route));
         } else {
             printf("NIEPOWODZENIE: %s\n", bdata(url));
         }

         bdestroy(url);
     }

     destroy_routes(routes);
     return 0;

 error:
     destroy_routes(routes);
     return 1;
 }
