 /*
 * Poniższy kod został oparty na kodzie Andre Reinald dość mocno zmodyfikowanym przez Zeda A. Shawa.
 */

 #include <stdio.h>
 #include <stdlib.h>
 #include <assert.h>
 #include <lcthw/radixmap.h>
 #include <lcthw/dbg.h>

 RadixMap *RadixMap_create(size_t max)
 {
     RadixMap *map = calloc(sizeof(RadixMap), 1);
     check_mem(map);

     map->contents = calloc(sizeof(RMElement), max + 1);
     check_mem(map->contents);

     map->temp = calloc(sizeof(RMElement), max + 1);
     check_mem(map->temp);

     map->max = max;
     map->end = 0;

     return map;
 error:
     return NULL;
 }

 void RadixMap_destroy(RadixMap * map)
 {
     if (map) {
         free(map->contents);
         free(map->temp);
         free(map);
     }
 }

 #define ByteOf(x,y) (((uint8_t *)x)[(y)])

 static inline void radix_sort(short offset, uint64_t max,
 uint64_t * source, uint64_t * dest)
 {
     uint64_t count[256] = { 0 };
     uint64_t *cp = NULL;
     uint64_t *sp = NULL;
     uint64_t *end = NULL;
     uint64_t s = 0;
     uint64_t c = 0;

     // Zliczenie wystąpień każdej wartości bajta.
     for (sp = source, end = source + max; sp < end; sp++) {
         count[ByteOf(sp, offset)]++;
     }

     // Przekształcenie liczby wystąpień na indeks przez zsumowanie
     // elementów i umieszczenie ich w tej samej tablicy.
     for (s = 0, cp = count, end = count + 256; cp < end; cp++) {
         c = *cp;
         *cp = s;
         s += c;
     }

     // Wypełnienie dest odpowiednimi wartościami w odpowiednich miejscach.
     for (sp = source, end = source + max; sp < end; sp++) {
         cp = count + ByteOf(sp, offset);
         dest[*cp] = *sp;
         ++(*cp);
     }
 }

 void RadixMap_sort(RadixMap * map)
 {
     uint64_t *source = &map->contents[0].raw;
     uint64_t *temp = &map->temp[0].raw;

     radix_sort(0, map->end, source, temp);
     radix_sort(1, map->end, temp, source);
     radix_sort(2, map->end, source, temp);
     radix_sort(3, map->end, temp, source);
 }

 RMElement *RadixMap_find(RadixMap * map, uint32_t to_find)
 {
     int low = 0;
     int high = map->end - 1;
     RMElement *data = map->contents;

     while (low <= high) {
         int middle = low + (high - low) / 2;
         uint32_t key = data[middle].data.key;

         if (to_find < key) {
             high = middle - 1;
         } else if (to_find > key) {
             low = middle + 1;
         } else {
             return &data[middle];
         }
     }

     return NULL;
 }

 int RadixMap_add(RadixMap * map, uint32_t key, uint32_t value)
 {
     check(key < UINT32_MAX, "Wartość klucza nie może być równa UINT32_MAX.");

     RMElement element = {.data = {.key = key,.value = value} };
     check(map->end + 1 < map->max, "Struktura RadixMap jest pełna.");

     map->contents[map->end++] = element;

     RadixMap_sort(map);

     return 0;

 error:
     return -1;
 }

 int RadixMap_delete(RadixMap * map, RMElement * el)
 {
     check(map->end > 0, "Nie ma niczego do usunięcia.");
     check(el != NULL, "Nie można usunąć elementu NULL.");

     el->data.key = UINT32_MAX;

     if (map->end > 1) {
         // Nie zawracamy sobie głowy przywróceniem mapy o wielkości jednego elementu.
         RadixMap_sort(map);
     }

     map->end--;

     return 0;
 error:
     return -1;
 }
