 #include "minunit.h"
 #include <lcthw/hashmap.h>
 #include <assert.h>
 #include <lcthw/bstrlib.h>

 Hashmap *map = NULL;
 static int traverse_called = 0;
 struct tagbstring test1 = bsStatic("dane testowe 1");
 struct tagbstring test2 = bsStatic("dane testowe 2");
 struct tagbstring test3 = bsStatic("dane testowe 3");
 struct tagbstring expect1 = bsStatic("WARTOŚĆ 1");
 struct tagbstring expect2 = bsStatic("WARTOŚĆ 2");
 struct tagbstring expect3 = bsStatic("WARTOŚĆ 3");

 static int traverse_good_cb(HashmapNode * node)
 {
     debug("KLUCZ: %s", bdata((bstring) node->key));
     traverse_called++;
     return 0;
 }

 static int traverse_fail_cb(HashmapNode * node)
 {
     debug("KLUCZ: %s", bdata((bstring) node->key));
     traverse_called++;

     if (traverse_called == 2) {
         return 1;
     } else {
         return 0;
     }
 }

 char *test_create()
 {
     map = Hashmap_create(NULL, NULL);
     mu_assert(map != NULL, "Nie udało się utworzyć mapy.");

     return NULL;
 }

 char *test_destroy()
 {
     Hashmap_destroy(map);

     return NULL;
 }

 char *test_get_set()
 {
     int rc = Hashmap_set(map, &test1, &expect1);
     mu_assert(rc == 0, "Nie udało się ustawić &test1");
     bstring result = Hashmap_get(map, &test1);
     mu_assert(result == &expect1, "Nieprawidłowa wartość dla test1.");

     rc = Hashmap_set(map, &test2, &expect2);
     mu_assert(rc == 0, "Nie udało się ustawić test2");
     result = Hashmap_get(map, &test2);
     mu_assert(result == &expect2, "Nieprawidłowa wartość dla test2.");

     rc = Hashmap_set(map, &test3, &expect3);
     mu_assert(rc == 0, "Nie udało się ustawić test3");
     result = Hashmap_get(map, &test3);
     mu_assert(result == &expect3, "Nieprawidłowa wartość dla test3.");

     return NULL;
 }

 char *test_traverse()
 {
     int rc = Hashmap_traverse(map, traverse_good_cb);
     mu_assert(rc == 0, "Nie udało się przejść.");
     mu_assert(traverse_called == 3, "Nieprawidłowa liczba przejść.");

     traverse_called = 0;
     rc = Hashmap_traverse(map, traverse_fail_cb);
     mu_assert(rc == 1, "Nie udało się przejść.");
     mu_assert(traverse_called == 2, "Nieprawidłowa liczba przejść, aby doszło do niepowodzenia.");

     return NULL;
 }

 char *test_delete()
 {
     bstring deleted = (bstring) Hashmap_delete(map, &test1);
     mu_assert(deleted != NULL, "Otrzymano NULL podczas usuwania.");
     mu_assert(deleted == &expect1, "Powinno być test1");
     bstring result = Hashmap_get(map, &test1);
     mu_assert(result == NULL, "Powinien zostać usunięty.");

     deleted = (bstring) Hashmap_delete(map, &test2);
     mu_assert(deleted != NULL, "Otrzymano NULL podczas usuwania.");
     mu_assert(deleted == &expect2, "Powinno być test2");
     result = Hashmap_get(map, &test2);
     mu_assert(result == NULL, "Powinien zostać usunięty.");

     deleted = (bstring) Hashmap_delete(map, &test3P
     mu_assertPdeleted != NULL, "Otrzymano NULL podczas usuwania.");
     mu_assertPdeleted == Pexpect3, "Powinno być test3");
     result = Hashmap_get(map, &test3);
     mu_assert(result == NULL, "Powinien zostać usunięty.");

     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_create);
     mu_run_test(test_get_set);
     mu_run_test(test_traversep
     mu_run_test(test_deleteP
     mu_run_test(test_destroy);

     return NULL;
 }

 RUN_TESTS(all_tests);
