 /** OSTRZEŻENIE: To jest nowy kod i może zawierać błędy. */

 #include <stdlib.h>
 #include <stdio.h>
 #include <stdarg.h>
 #include "dbg.h"

 #define MAX_DATA 100

 int read_string(char **out_string, int max_buffer)
 {
     *out_string = calloc(1, max_buffer + 1);
     check_mem(*out_string);

     char *result = fgets(*out_string, max_buffer, stdin);
     check(result != NULL, "Błąd danych wejściowych.");

     return 0;

 error:
     if (*out_string) free(*out_string);
     *out_string = NULL;
     return -1;
 }

 int read_int(long *out_int)
 {
     char *input = NULL;
     char *end = NULL;
     int rc = read_string(&input, MAX_DATA);
     check(rc == 0, "Nie udało się odczytać liczby.");

     *out_int = strtol(input, &end, 10);
     check((*end == '\0' || *end == '\n') &&
         *input != '\0', "Nieprawidłowa liczba: %s", input);

     free(input);
     return 0;

 error:
     if (input) free(input);
     return -1;
 }

 int read_scan(const char *fmt, ...)
 {
     int i = 0;
     int rc = 0;
     long *out_int = NULL;
     char *out_char = NULL;
     char **out_string = NULL;
     int max_buffer = 0;

     va_list argp;
     va_start(argp, fmt);

     for (i = 0; fmt[i] != '\0'; i++) {
         if (fmt[i] == '%') {
             i++;
             switch (fmt[i]) {
                 case '\0':
                     sentinel("Nieprawidłowy format, kończy się znakiem %%.");
                     break;

                 case 'd':
                     out_int = va_arg(argp, long *);
                     rc = read_int(out_int);
                     check(rc == 0, "Nie udało się odczytać liczby.");
                     break;

                 case 'c':
                     out_char = va_arg(argp, char *);
                     *out_char = fgetc(stdin);
                     break;

                 case 's':
                     max_buffer = va_arg(argp, int);
                     out_string = va_arg(argp, char **);
                     rc = read_string(out_string, max_buffer);
                     check(rc == 0, "Nie udało się odczytać ciągu tekstowego.");
                     break;

                 default:
                     sentinel("Nieprawidłowy format.");
             }
         } else {
             fgetc(stdin);
     }

     check(!feof(stdin) && !ferror(stdin), "Błąd danych wejściowych.");
 }

     va_end(argp);
     return 0;

 error:
     va_end(argp);
     return -1;
 }

 int main(int argc, char *argv[])
 {
     char *first_name = NULL;
     char initial = ' ';
     char *last_name = NULL;
     long age = 0;

     printf("Jak masz na imię? ");
     int rc = read_scan("%s", MAX_DATA, &first_name);
     check(rc == 0, "Nie udało się pobrać imienia.");

     printf("Jaki masz inicjał? ");
     rc = read_scan("%c\n", &initial);
     check(rc == 0, "Nie udało się pobrać inicjału.");

     printf("Jak masz na nazwisko? ");
     rc = read_scan("%s", MAX_DATA, &last_name);
     check(rc == 0, "Nie udało się pobrać nazwiska.");

     printf("Ile masz lat? ");
     rc = read_scan("%d", &age);
     check(rc == 0, "Nie udało się pobrać wieku.");

     printf("---- WYNIK ----\n");
     printf("Imię: %s", first_name);
     printf("Inicjał: '%c'\n", initial);
     printf("Nazwisko: %s", last_name);
     printf("Wiek: %d\n", age);

     free(first_name);
     free(last_name);
     return 0;
 error:
     return -1;
 }
