 #include "dbg.h"
 #include <stdlib.h>
 #include <stdio.h>

 void test_debug()
 {
     // Zwróć uwagę na brak konieczności użycia \n.
     debug("Mam brązowe włosy.");

     // Przekazanie argumentów, podobnie jak w wywołaniu printf().
     debug("Mam %d lat.", 37);
 }

 void test_log_err()
 {
     log_err("Jestem przekonany, że wszystko jest zepsute.");
     log_err("Mamy %d problemów w %s.", 0, "kosmosiie.");
 }

 void test_log_warn()
 {
     log_warn("Możesz to bezpiecznie zignorować.");
     log_warn("Rozważ przeanalizowanie: %s.", "/etc/passwd");
 }

 void test_log_info()
 {
     log_info("Cóż, zrobiłem coś prozaicznego.");
     log_info("To zdarza się %f razy dziennie.", 1.3f);
 }

 int test_check(char *file_name)
 {
     FILE *input = NULL;
     char *block = NULL;

     block = malloc(100);
     check_mem(block); // To powinno działać.

     input = fopen(file_name, "r");
     check(input, "Nie udało się otworzyć pliku %s.", file_name);

     free(block);
     fclose(input);
     return 0;

 error:
     if (block) free(block);
     if (input) fclose(input);
     return -1;
 }

 int test_sentinel(int code)
 {
     char *temp = malloc(100);
     check_mem(temp);

     switch (code) {
         case 1:
             log_info("To działa.");
             break;
         default:
             sentinel("To nie powinno być uruchomione.");
     }

     free(temp);
     return 0;

 error:
     if (temp)
         free(temp);
     return -1;
 }

 int test_check_mem()
 {
     char *test = NULL;
     check_mem(test);

     free(test);
     return 1;

 error:
     return -1;
 }

 int test_check_debug()
 {
     int i = 0;
     check_debug(i != 0, "Ups, mam wartość 0.");

     return 0;
 error:
     return -1;
 }

 int main(int argc, char *argv[])
 {
     check(argc == 2, "Wymagany jest argument.");

     test_debug();
     test_log_err();
     test_log_warn();
     test_log_info();

     check(test_check("ex19.c") == 0, "nie udało się z powodu ex19.c");
     check(test_check(argv[1]) == -1, "nie udało się z powodu argv");
     check(test_sentinel(1) == 0, "niepowodzenie makra test_sentinel.");
     check(test_sentinel(100) == -1, "niepowodzenie makra test_sentinel.");
     check(test_check_mem() == -1, "niepowodzenie makra test_check_mem.");
     check(test_check_debug() == -1, "niepowodzenie makra test_check_debug.");

     return 0;

 error:
     return 1;
 }
