 #undef NDEBUG
 #include "dbg.h"
 #include <stdio.h>
 #include <assert.h>

 /*
 * Naiwne kopiowanie po przyjęciu założenia, że wszystkie dane wejściowe zawsze będą prawidłowe.
 * Przykład na podstawie wersji K&R C, jedynie nieco uporządkowany.
 */
 void copy(char to[], char from[])
 {
     int i = 0;

     // Działanie pętli while nie zakończy się, jeśli na końcu zabraknie znaku '\0'.
     while ((to[i] = from[i]) != '\0') {
         ++i;
     }
 }

 /*
 * Bezpieczniejsza wersja sprawdzająca pod kątem wielu najczęściej występujących błędów.
 * Długość każdego ciągu tekstowego wykorzystano do kontrolowania pętli i zakończenia jej działania.
 */
 int safercopy(int from_len, char *from, int to_len, char *to)
 {
     assert(from != NULL && to != NULL && "Zmienne from i to nie mogą mieć wartości NULL.");
     int i = 0;
     int max = from_len > to_len - 1 ? to_len - 1 : from_len;

     // Wielkość to_len musi wynosić przynajmniej 1 bajt.
     if (from_len < 0 || to_len <= 0)
         return -1;

     for (i = 0; i < max; i++) {
         to[i] = from[i];
     }

     to[to_len - 1] = '\0';

     return i;
 }

 int main(int argc, char *argv[])
 {
     // Postaraj się dokładnie zrozumieć, dlaczego możemy ustalić te wielkości
     char from[] = "0123456789";
     int from_len = sizeof(from);

     // Zwróć uwagę, że to jest 7 znaków plus \0.
     char to[] = "0123456";
     int to_len = sizeof(to);

     debug("Kopiowanie '%s':%d do '%s':%d", from, from_len, to, to_len);

     int rc = safercopy(from_len, from, to_len, to);
     check(rc > 0, "Nie udało się skopiować danych.");
     check(to[to_len - 1] == '\0', "Ciąg tekstowy jest nieprawidłowo zakończony.");

     debug("Wynik: '%s':%d", to, to_len);

     // Teraz spróbujemy zepsuć kod.
     rc = safercopy(from_len * -1, from, to_len, to);
     check(rc == -1, "Kopiowanie powinno zakończyć się niepowodzeniem #1");
     check(to[to_len - 1] == '\0', "Ciąg tekstowy jest nieprawidłowo zakończony.");

     rc = safercopy(from_len, from, 0, to);
     check(rc == -1, "Kopiowanie powinno zakończyć się niepowodzeniem #2");
     check(to[to_len - 1] == '\0', "Ciąg tekstowy jest nieprawidłowo zakończony.");

     return 0;

 error:
     return 1;
 }
