 #include <stdio.h>
 #include "dbg.h"

 #define MAX_DATA 100

 typedef enum EyeColor {
     BLUE_EYES, GREEN_EYES, BROWN_EYES,
     BLACK_EYES, OTHER_EYES
 } EyeColor;

 const char *EYE_COLOR_NAMES[] = {
     "niebieski", "zielony", "brązowy", "czarny", "inny"
 };

 typedef struct Person {
     int age;
     char first_name[MAX_DATA];
     char last_name[MAX_DATA];
     EyeColor eyes;
     float income;
 } Person;

 int main(int argc, char *argv[])
 {
     Person you = {.age = 0 };
     int i = 0;
     char *in = NULL;

     printf("Jak masz na imię? ");
     in = fgets(you.first_name, MAX_DATA - 1, stdin);
     check(in != NULL, "Nie udało się odczytać imienia.");

     printf("Jak masz na nazwisko? ");
     in = fgets(you.last_name, MAX_DATA - 1, stdin);
     check(in != NULL, "Nie udało się odczytać nazwiska.");

     printf("Ile masz lat? ");
     int rc = fscanf(stdin, "%d", &you.age);
     check(rc > 0, "Musisz podać liczbę.");

     printf("Jaki masz kolor oczu:\n");
     for (i = 0; i <= OTHER_EYES; i++) {
         printf("%d) %s\n", i + 1, EYE_COLOR_NAMES[i]);
     }
     printf("> ");

     int eyes = -1;
     rc = fscanf(stdin, "%d", &eyes);
     check(rc > 0, "Musisz podać liczbę.");

     you.eyes = eyes - 1;
     check(you.eyes <= OTHER_EYES
         && you.eyes >= 0, "Zrób to dobrze, nie ma takiej opcji.");

     printf("Ile zarabiasz na godzinę? ");
     rc = fscanf(stdin, "%f", &you.income);
     check(rc > 0, "Podaj liczbę zmiennoprzecinkową.");

     printf("----- WYNIK -----\n");

     printf("Imię: %s", you.first_name);
     printf("Nazwisko: %s", you.last_name);
     printf("Wiek: %d\n", you.age);
     printf("Kolor oczu: %s\n", EYE_COLOR_NAMES[you.eyes]);
     printf("Dochód: %f\n", you.income);

     return 0;
     error:

     return -1;
 }
