 #include <stdio.h>

 int main(int argc, char *argv[])
 {
     // Utworzenie dwóch potrzebnych nam tablic danych.
     int ages[] = { 25, 437, 12, 89, 5 };
     char *names[] = {
         "Alan", "Franek",
         "Mariusz", "Janek", "Ludwik"
     };

     // Bezpieczne ustalenie wielkości tablicy ages.
     int count = sizeof(ages) / sizeof(int);
     int i = 0;

     // Pierwszy sposób opiera się na indeksach.
     for (i = 0; i < count; i++) {
         printf("%s przeżył %d lat.\n", names[i], ages[i]);
     }

     printf("---\n");

     // Ustawienie wskaźników tak, aby wskazywały początek tablic.
     int *cur_age = ages;
     char **cur_name = names;

     // Drugi sposób opiera się na wskaźnikach.
     for (i = 0; i < count; i++) {
         printf("%s ma %d lat.\n",
             *(cur_name + i), *(cur_age + i));
     }

     printf("---\n");

     // Trzeci sposób to użycie wskaźników, jakby po prostu były tablicami.
     for (i = 0; i < count; i++) {
         printf("%s żyje od %d lat.\n", cur_name[i], cur_age[i]);
     }

     printf("---\n");

     // Czwarty sposób też opiera się na wskaźnikach, ale użytych w bezsensownie skomplikowany sposób.
     for (cur_name = names, cur_age = ages;
             (cur_age - ages) < count;
             cur_name++, cur_age++) {
         printf("%s przeżył jak dotąd %d lat.\n", *cur_name, *cur_age);
     }

     return 0;
 }
