
//
// To jest przykadowy kod z podrozdziau 25.3.4 Przykad uycia stosu ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <stddef.h> 

//------------------------------------------------------------------------------

template<int N>class Stack { // Stos N bajtw.
public:
    Stack();                 // Tworzy stos N bajtw.
    void* get(int n);        // Alokuje n bajtw na stosie.
                             // Zwraca 0, jeli nie ma wolnego miejsca.
    void free();             // Zwraca na stos ostatni warto zwrcon przez get().
    int available() const;   // Liczba dostpnych bajtw.
private:
    // Przestrze dla char[N] i danych do ledzenia, co zostao alokowane,
    // a co nie (np. wskanik wskazujcy wierzch stosu).
};

//------------------------------------------------------------------------------

class Port;
class Buffer;

//------------------------------------------------------------------------------

class Connection
{
public:
    Connection(Port* in, Port* out, int* buf);
    void* operator new(size_t size, void* place);
};

//------------------------------------------------------------------------------

extern Port* incoming;
extern Port* outgoing;

//------------------------------------------------------------------------------

int main()
{
    Stack<50*1024> my_free_store; // 50 KB pamici zostao zarezerwowanych dla stosu.

    void* pv1 = my_free_store.get(1024);
    int* buffer = static_cast<int*>(pv1);  

    void* pv2 = my_free_store.get(sizeof(Connection));
    Connection* pconn = new(pv2) Connection(incoming,outgoing,buffer);
}

//------------------------------------------------------------------------------
