
//
// To jest przykadowy kod z podrozdziau 17.9.1 Wskaniki i referencje jako parametry ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

int  incr_v(int x) { return x+1; } // Oblicza now warto i j zwraca.
void incr_p(int* p) { ++*p; }      // przekazanie wskanika
                                   // (wyuskanie go i inkrementacja wyniku)
void incr_r(int& r) { ++r; }       // przekazanie referencji
void incr_p(char* p)
{
    if (p==0) error("Zerowy wskanik podany jako argument funkcji incr_p().");
    ++*p; // Dereferencja wskanika i inkrementacja wskazywanego przez niego obiektu.
}

//------------------------------------------------------------------------------

int main()
try
{
    {
        int x = 2;
        x = incr_v(x); // Kopiuje x do incr_v(); nastpnie kopiuje wynik na zewntrz i przypisuje go.
    }

    // Uycie wskanika jako argumentu jest znakiem dla programisty, e co moe si zmieni.
    {
        int x = 7;
        incr_p(&x);    // Operator & jest potrzebny.
        incr_r(x);
    }

    // Kto mgby to wywoa przy uyciu pustego wskanika.
    {
        //incr_p(0);     // Awaria: funkcja incr_p() bdzie prbowa wyuska 0.
        char* p = 0;
        incr_p(p);     // Awaria: funkcja incr_p() bdzie prbowa wyuska 0.
    }
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
