
//
// To jest przykadowy kod z podrozdziau 10.7.2 Oddzielenie warstwy komunikacyjnej od funkcji ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

void skip_to_int()
{
    if (cin.fail()) {          // Znaleziono co, co nie jest liczb cakowit.
        cin.clear();           // Chcemy przyjrze si znakom.
        char ch;
        while (cin>>ch){       // Odrzuca niecyfry.
            if (isdigit(ch)) {
                cin.unget();   // Oddaje cyfr z powrotem, dziki czemu mona odczyta liczb.
                               
                return;
            }
        }
    }
    error("Brak danych.");         // Stan eof lub bad  poddajemy si.
}

//------------------------------------------------------------------------------

int get_int()
{
    int n = 0;
    while (true) {
        if (cin >> n) return n;
        cout << "Niestety, to nie bya liczba. Sprbuj jeszcze raz.\n";
        skip_to_int();
    }
}

//------------------------------------------------------------------------------

int get_int(int low, int high, const string& greeting, const string& sorry)
{
    cout << greeting << ": [" << low << ':' << high << "]\n";

    while (true) {
        int n = get_int();
        if (low<=n && n<=high) return n;
        cout << sorry  << ": [" << low << ':' << high << "]\n";
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    int strength = get_int(1,10, "Okrel si.", "Liczba spoza zakresu. Sprbuj ponownie.");
    cout << "Sia: " << strength << endl;

    int altitude = get_int(0,50000,
                           "Podaj wysoko nad poziomem morza w metrach.",
                           "Liczba spoza zakresu. Sprbuj ponownie.");
    cout << "Wysoko: " << altitude << "f nad poziomem morza.\n";
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
