
//
// Przykadowy kod z rozdziau 6.6 "Wyprbowywanie pierwszej wersji" ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

class Token {
public:
    char kind;        // rodzaj tokenu
    double value;     // Dla liczb: warto. 
    Token(char ch)    // Tworzy Token ze znaku.
        :kind(ch), value(0) { }    
    Token(char ch, double val)     // Tworzy Token ze znaku i wartoci typu double.
        :kind(ch), value(val) { }
};

//------------------------------------------------------------------------------

class Token_stream {
public: 
    Token_stream();   // Tworzy Token_stream wczytujcy ze strumienia cin.
    Token get();      // Pobiera token.
    void putback(Token t); // Wstawia token z powrotem.
private:
    // szczegy implementacyjne
};

//------------------------------------------------------------------------------

Token_stream ts;      // globalny strumie tokenw

//------------------------------------------------------------------------------

double expression();  // Wczytuje i wartociuje wyraenie.

//------------------------------------------------------------------------------

double term();        // Wczytuje i wartociuje skadnik.

//------------------------------------------------------------------------------

double primary();     // Wczytuje i wartociuje czynnik.

//------------------------------------------------------------------------------

int main()
try {
    while (cin)
        cout << expression() << '\n';
    keep_window_open();
}
catch (exception& e) {
    cerr << e.what() << endl;
    keep_window_open ();
    return 1;
}
catch (...) {
    cerr << "Wyjtek \n";
    keep_window_open ();
    return 2;
}

//------------------------------------------------------------------------------

double expression()
{
    double left = term(); // Wczytuje i wartociuje skadnik.
    Token t = ts.get();   // Pobiera nastpny token ze strumienia.

    while(true) {    
        switch(t.kind) {
    case '+':
        left += term();   // Wartociuje skadnik i wykonuje dodawanie.
        t = ts.get();
        break;
    case '-':
        left -= term();   // Wartociuje skadnik i wykonuje odejmowanie.
        t = ts.get();
        break;
    default: 
        ts.putback(t);    // Wstawia token t z powrotem do strumienia tokenw.
        return left;      // Jeli nie ma wicej znakw + lub , zwraca odpowied.
        }
    }
}

//------------------------------------------------------------------------------

double term()
{
    double left = primary();
    Token t = ts.get();   // Pobiera nastpny token ze strumienia.

    while(true) {
        switch (t.kind) {
        case '*':
            left *= primary();
            t = ts.get();
            break;
        case '/':
            {    
                double d = primary();
                if (d == 0) error("Dzielenie przez zero.");
                left /= d; 
                t = ts.get();
                break;
            }
        default: 
            ts.putback(t); // Wstawia token t z powrotem do strumienia tokenw.
            return left;
        }
    }
}

//------------------------------------------------------------------------------
