REM $Id: uzytkbibl.pkb,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 341

REM Ciao pakietu, ktry zarzdza rekordami uytkownikw tabeli uzytk_bibl

CREATE OR REPLACE PACKAGE BODY uzytkbibl
AS

   /* Doda w razie koniecznoci pobierania danych
   | TYPE refcur_t IS REF CURSOR;
   */

   FUNCTION id_nowego_uzytk(nazwa_uzytk IN VARCHAR2,
      zwyklytekst_haslo IN VARCHAR2,
      email_adres IN VARCHAR2,
      id_karty IN VARCHAR2,
      id_wykonawcy IN NUMBER)
   RETURN PLS_INTEGER
   IS
      l_id_uzytk PLS_INTEGER;
   BEGIN
      uprawn.dostep_dozwolony(id_wykonawcy, uprawn.dodaj_uzytk_c);

      INSERT INTO uzytk_bibl (id, nazwa_uzytk,
         zaszyfrowane_haslo,
         data_utworz_konta, adres_email, idkarty)
      VALUES (uzytkbibl_seq.NEXTVAL, nazwa_uzytk,
         nopu.zaszyfrowane_haslo(nazwa_uzytk, zwyklytekst_haslo),
         SYSDATE, email_adres, id_karty)
      RETURNING id INTO l_id_uzytk;

      RETURN l_id_uzytk;
   END id_nowego_uzytk;


   PROCEDURE zmien(id_uzytk IN VARCHAR2,
      nazwa_uzytk_in IN VARCHAR2,
      zwyklytekst_haslo_in IN VARCHAR2,
      email_adres_in IN VARCHAR2,
      id_karty_in IN VARCHAR2,
      id_wykonawcy IN NUMBER)
   IS
   BEGIN
      uprawn.dostep_dozwolony(id_wykonawcy, uprawn.edytuj_uzytk_c);
      UPDATE uzytk_bibl
         SET zaszyfrowane_haslo =
                nopu.zaszyfrowane_haslo(nazwa_uzytk_in, zwyklytekst_haslo_in),
             nazwa_uzytk = nazwa_uzytk_in,
             adres_email = email_adres_in,
             idkarty = id_karty_in
       WHERE id = id_uzytk;
       IF SQL%NOTFOUND
       THEN
          RAISE NO_DATA_FOUND;
       END IF;
   END zmien;


   PROCEDURE usun(id_uzytk IN NUMBER,
      id_wykonawcy IN NUMBER)
   IS
   BEGIN
      uprawn.dostep_dozwolony(id_wykonawcy, uprawn.usun_uzytk_c);
      nopu.okresl_nie_null(id_uzytk);
      DELETE uzytk_bibl WHERE id = id_uzytk;
      IF SQL%ROWCOUNT = 0
      THEN
         RAISE NO_DATA_FOUND;
      END IF;
   END usun;


   FUNCTION id_uzytk_zidentyfikowanego(nazwa_uzytk_in IN VARCHAR2,
      zwyklytekst_haslo_in IN VARCHAR2)
   RETURN PLS_INTEGER
   IS
      CURSOR ucur
      IS
         SELECT id
           FROM uzytk_bibl
          WHERE UPPER(nazwa_uzytk) = UPPER(nazwa_uzytk_in)
            AND zaszyfrowane_haslo =
                nopu.zaszyfrowane_haslo(nazwa_uzytk_in, zwyklytekst_haslo_in);
      urow ucur%ROWTYPE;

   BEGIN
      nopu.okresl_nie_null(nazwa_uzytk_in);
      nopu.okresl_nie_null(zwyklytekst_haslo_in);

      /* Jeli id uytkownika i wygenerowane haso odpowiadaj wartoci
      | przechowywanej w systemie (patrz wyraenie WHERE w "ucur" powyej), to
      | proces koczony jest pomylnie, i mona powrci do id uytkownika
      */

      OPEN ucur;
      FETCH ucur INTO urow;
      IF ucur%NOTFOUND
      THEN
         CLOSE ucur;
         exc.mojeraise(exc.nie_zalogowany_cd);
      END IF;
      CLOSE ucur;

      RETURN urow.id;
   END id_uzytk_zidentyfikowanego;

/* Doda w razie koniecznoci pobierania danych

   FUNCTION user_cur (pk IN VARCHAR2,
      param1 IN VARCHAR2,
      param2 IN VARCHAR2,
      startrec IN VARCHAR2 DEFAULT '1',
      wierszy_do_pobrania IN VARCHAR2 DEFAULT 'ALL',
      orderby IN VARCHAR2 DEFAULT '1')
      RETURN refcur_t
   IS
     ...tutaj implementacja...
   END;
*/

END uzytkbibl;
/

SHOW ERRORS
