REM $Id: priv.pkb,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 338

REM Ciao pakietu, ktry zarzdza uprawnieniami systemu bibliotecznego

CREATE OR REPLACE PACKAGE BODY uprawn
AS
   PROCEDURE dostep_dozwolony (id_uzytk_in IN NUMBER, id_uprawn_in IN NUMBER)
   IS
      CURSOR ucur
      IS
         SELECT NULL
           FROM uprawnienia_uzytk_bibl
          WHERE id_uzytkownika = id_uzytk_in
            AND id_uprawnienia = id_uprawn_in;
         urow ucur%ROWTYPE;
   BEGIN
      nopu.okresl_nie_null(id_uzytk_in);
      nopu.okresl_nie_null(id_uprawn_in);

      OPEN ucur;
      FETCH ucur INTO urow;
      IF ucur%NOTFOUND
      THEN
         CLOSE ucur;
         exc.mojeraise(exc.wymagana_autoryzacja_cd);
      END IF;
      CLOSE ucur;
   END;

   PROCEDURE nadaj_uprawn (id_uprawn_in IN NUMBER,
      id_uzytk_in IN NUMBER, id_wykonawcy IN NUMBER)
   IS
   BEGIN
      dostep_dozwolony(id_wykonawcy, uprawn.nadaj_uprawn_c);
      INSERT INTO uprawnienia_uzytk_bibl (id_uzytkownika, id_uprawnienia)
      VALUES (id_uzytk_in, id_uprawn_in);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX
      THEN
         NULL;
   END;

   PROCEDURE odbierz_uprawn (id_uprawn_in IN NUMBER,
      id_uzytk_in IN NUMBER, id_wykonawcy IN NUMBER)
   IS
   BEGIN
      dostep_dozwolony(id_wykonawcy, uprawn.odbierz_uprawn_c);
      DELETE uprawnienia_uzytk_bibl
       WHERE id_uzytkownika = id_uzytk_in
         AND id_uprawnienia = id_uprawn_in;
   END;

END;
/

SHOW ERRORS

