REM $Id: ksiazkaweb.pkb,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 9

REM Ciao wersji z rozdziau 9 pakietu ksiazkaweb, w ktrej dodano funkcje
REM zabezpieczajce do wersji z rozdziau 4

CREATE OR REPLACE PACKAGE BODY ksiazkaweb
AS
   FUNCTION weryfikuj (isbn IN VARCHAR2,
      tytul IN VARCHAR2 DEFAULT NULL,
      autor IN VARCHAR2 DEFAULT NULL,
      liczba_stron_lanc IN VARCHAR2 DEFAULT NULL,
      opis IN VARCHAR2 DEFAULT NULL,
      rrrr_wydania IN VARCHAR2 DEFAULT NULL,
      mies_wydania IN VARCHAR2 DEFAULT NULL,
      dd_wydania IN VARCHAR2 DEFAULT NULL,
      podlanc_tylko IN BOOLEAN DEFAULT FALSE,
      id_tylko BOOLEAN DEFAULT FALSE)
      RETURN ksiazkarec_t
   IS
      kr ksiazkarec_t;
   BEGIN

      kr.isbn := SUBSTR(isbn, 1, 13);

      IF NOT id_tylko
      THEN
         kr.autor := SUBSTR(autor, 1, 200);
         kr.tytul := SUBSTR(tytul, 1, 200); 
         kr.opis := SUBSTR(opis, 1, 2000); 
         kr.liczba_stron_lanc := SUBSTR(liczba_stron_lanc, 1, 40);
         kr.rrrr_wydania := SUBSTR(rrrr_wydania, 1, 4);
         kr.mies_wydania := SUBSTR(mies_wydania, 1, 3);
         kr.dd_wydania := SUBSTR(dd_wydania, 1, 2);
      END IF;

      IF podlanc_tylko
      THEN
         RETURN kr;
      END IF;

      kr.poprawnie := nopu.sqltrue;

      IF NOT nopu.lanc_pasuje(isbn,10,13)
      THEN
         kr.isbn_kom := 'Musi mie 10 do 13 znakw';
         kr.poprawnie := nopu.sqlfalse;
      END IF;

      IF id_tylko
      THEN
         RETURN kr;
      END IF;

      IF NOT nopu.lanc_pasuje(autor,0,200)
      THEN
         kr.autor_kom := 'Musi mie mniej ni 200 znakw';
         kr.poprawnie := nopu.sqlfalse;
      END IF;

      IF NOT nopu.lanc_pasuje(tytul, 0, 200)
      THEN
         kr.tytul_kom := 'Musi mie mniej ni 200 znakw';
         kr.poprawnie := nopu.sqlfalse;
      END IF;

      IF NOT nopu.lanc_pasuje(opis, 0, 2000)
      THEN
         kr.opis_kom := 'Musi mie mniej ni 2000 znakw';
         kr.poprawnie := nopu.sqlfalse;
      END IF;

      IF nopu.czy_number(liczba_stron_lanc)
      THEN
         kr.liczba_stron := TO_NUMBER(liczba_stron_lanc);
         kr.liczba_stron_lanc := TO_CHAR(kr.liczba_stron);
      ELSE
         kr.liczba_stron_kom := 'Musi by liczb';
         kr.poprawnie := nopu.sqlfalse;
      END IF;

      IF nopu.czy_date(rrrr_wydania || mies_wydania || dd_wydania)
      THEN
         kr.data_wydania := TO_DATE(
            rrrr_wydania || mies_wydania || dd_wydania,
            nopu.dflt_date_format);
         kr.rrrr_wydania := TO_CHAR(kr.data_wydania, 'YYYY');
         kr.mies_wydania := TO_CHAR(kr.data_wydania, 'MON');
         kr.dd_wydania := TO_CHAR(kr.data_wydania, 'DD');
      ELSE
         kr.data_wydania_kom := 'Musi by poprawn dat';
         kr.poprawnie := nopu.sqlfalse;
      END IF;

      RETURN kr;

   END weryfikuj;


   FUNCTION jedna_ksiazka(isbn_in IN VARCHAR2)
      RETURN ksiazkarec_t
   IS
      kr ksiazkarec_t;
      kr_holder ksiazkarec_t;
      CURSOR kc IS
         SELECT isbn, tytul, autor, liczba_stron, TO_CHAR(liczba_stron),
                opis, data_wydania,
                TO_CHAR(data_wydania, 'YYYY'),
                TO_CHAR(data_wydania, 'MON'),
                TO_CHAR(data_wydania, 'DD'),
                NULL, NULL, NULL, NULL, NULL, NULL, NULL, nopu.sqltrue
           FROM ksiazki
          WHERE isbn = isbn_in;
   BEGIN
      kr_holder := weryfikuj(isbn_in, id_tylko => TRUE);
      IF kr_holder.poprawnie = nopu.sqltrue
      THEN
         OPEN kc;
         FETCH kc INTO kr;
         IF kc%NOTFOUND
         THEN
            kr := kr_holder;
            kr.action_kom := 'Nowa ksika.';
         END IF;
         CLOSE kc;
      ELSE
         kr := kr_holder;
      END IF;
      RETURN kr;
   END jedna_ksiazka;


   FUNCTION przetworz_wpisy (
      id_sesji IN VARCHAR2,
      pomin IN VARCHAR2,
      wyslij IN VARCHAR2,
      isbn IN VARCHAR2,
      tytul IN VARCHAR2,
      autor IN VARCHAR2,
      liczba_stron IN VARCHAR2,
      opis IN VARCHAR2,
      rrrr_wydania IN VARCHAR2,
      mies_wydania IN VARCHAR2,
      dd_wydania IN VARCHAR2,
      nowe_kody_kresk_arr IN OWA_UTIL.IDENT_ARR,
      usun_egzemplarze_arr IN OWA_UTIL.IDENT_ARR
      )
      RETURN ksiazkarec_t
   IS
      kr ksiazkarec_t;
   BEGIN
      nopu.ustaw_dflt_date_format('YYYYMONDD');

      IF pomin IS NOT NULL
      THEN
         kr := weryfikuj(isbn, tytul, autor, liczba_stron, opis,
                      rrrr_wydania, mies_wydania, dd_wydania,
                      podlanc_tylko => TRUE);

      ELSIF (wyslij IS NULL OR wyslij = webu.edytuj_c)
      THEN
         IF isbn IS NOT NULL
         THEN
            kr := jedna_ksiazka(isbn_in => isbn);
         END IF;

      ELSIF wyslij = webu.zachowaj_c
      THEN
         -- uprawnweb.dostep_dozwolony(id_sesji, uprawn.edytuj_ksiazka_c);
         
         kr := weryfikuj(isbn, tytul, autor, liczba_stron, opis,
                      rrrr_wydania, mies_wydania, dd_wydania);

         IF kr.poprawnie = nopu.sqltrue
         THEN
            BEGIN
               ksiazka.zmien(isbn_in => kr.isbn, nowy_tytul => kr.tytul,
                 nowy_autor => kr.autor, nowa_liczba_stron => kr.liczba_stron,
                 nowy_opis => kr.opis,
                 nowa_data_wydania => kr.data_wydania,
                 id_wykonawcy => uprawnweb.id_uzytk(id_sesji));
                 kr.action_kom := 'Zapisano zmiany w ' || kr.isbn || '.';
            EXCEPTION
               WHEN NO_DATA_FOUND
               THEN
                  ksiazka.dodaj(isbn_in => kr.isbn, tytul_in => kr.tytul,
                    autor_in => kr.autor, liczba_stron_in => kr.liczba_stron,
                    opis_in => kr.opis,
                    data_wydania_in => kr.data_wydania,
                    id_wykonawcy => uprawnweb.id_uzytk(id_sesji));
                    kr.action_kom := 'Dodano ' || kr.isbn || ' do bazy danych.';
            END;

            BEGIN
               IF nowe_kody_kresk_arr.FIRST IS NOT NULL
               THEN
                  -- uprawnweb.dostep_dozwolony(id_sesji, uprawn.edytuj_egzemp_ksiazki_c);
                  FOR i IN nowe_kody_kresk_arr.FIRST .. nowe_kody_kresk_arr.LAST
                  LOOP
                     IF nowe_kody_kresk_arr(i) IS NOT NULL
                     THEN
                        ksiazka.dodaj_egzemplarz(isbn, nowe_kody_kresk_arr(i),
                           id_wykonawcy => uprawnweb.id_uzytk(id_sesji));
                     END IF;
                  END LOOP;
               END IF;

               IF usun_egzemplarze_arr.FIRST IS NOT NULL
               THEN
                  -- uprawnweb.dostep_dozwolony(id_sesji, uprawn.usun_egzemp_ksiazki_c);
                  FOR i IN usun_egzemplarze_arr.FIRST .. usun_egzemplarze_arr.LAST
                  LOOP
                     IF usun_egzemplarze_arr(i) IS NOT NULL
                     THEN
                        ksiazka.usun_egzemplarz(isbn, usun_egzemplarze_arr(i),
                           id_wykonawcy => uprawnweb.id_uzytk(id_sesji));
                     END IF;
                  END LOOP;
               END IF;
            EXCEPTION
            WHEN OTHERS
               THEN 
                  kr.poprawnie := nopu.sqlfalse;
                  kr.action_kom := 'Zmian nie zapisano.';
            END;

         ELSE
            kr.action_kom := 'Zmian nie zapisano.';
         END IF;

      ELSIF wyslij = webu.usun_c
      THEN
         -- uprawnweb.dostep_dozwolony(id_sesji, uprawn.usun_ksiazke_c);
         kr := weryfikuj(isbn, id_tylko => TRUE);

         IF kr.poprawnie = nopu.sqltrue
         THEN
            BEGIN
               ksiazka.usun(isbn_in => isbn,
                  id_wykonawcy => uprawnweb.id_uzytk(id_sesji));
               kr := NULL;
               kr.action_kom := 'Usunito ' || isbn || '.';
               kr.poprawnie := nopu.sqltrue;
            EXCEPTION
               WHEN NO_DATA_FOUND
               THEN
                  kr.action_kom := isbn || ' nie znaleziono.';
                  kr.poprawnie := nopu.sqlfalse;
            END;
         ELSE
            kr.action_kom := 'Nie usunito ' || isbn;
         END IF;

      ELSIF wyslij = webu.nowe_szukanie_c
      THEN
         HTP.INIT;
         OWA_UTIL.REDIRECT_URL('ksiazkaszukanie?id_sesji_=' || id_sesji);

      ELSE
         kr := NULL;
         kr.action_kom := 'danie wykonania nieznanej akcji: ' || wyslij;
      END IF;

      RETURN kr;

    END przetworz_wpisy;

END ksiazkaweb;
/

SHOW ERRORS

