REM $Id: ksiazki_hist_trg.trg,v 1.1 2001/11/30 23:22:18 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 254

REM Tworzy wyzwalacz zachowujcy informacje o zmianch dokonywanych w tabeli ksiazki

CREATE OR REPLACE TRIGGER ksiazki_hist_trg
   AFTER INSERT OR UPDATE OR DELETE
   ON ksiazki
   FOR EACH ROW
DECLARE
   l_akcja CHAR(1);
BEGIN

   IF :NEW.isbn != :OLD.isbn
   THEN
      exc.mojeraise(exc.niedozw_zmiana_niepowt_id_cd);
   END IF;

   IF INSERTING
   THEN
      l_akcja := 'I';
   ELSIF UPDATING
   THEN
      l_akcja := 'U';
   ELSIF DELETING
   THEN
      l_akcja := 'D';
   END IF;

   INSERT INTO ksiazki_hist
      (isbn, akcja, znacznikdaty, uzytk_oracle, uzytk_prawdziwy,
       stary_tytul, stary_opis, stary_autor,
       stara_data_wydania, stara_liczba_stron,
       nowy_tytul, nowy_opis, nowy_autor,
       nowa_data_wydania, nowa_liczba_stron)
   VALUES 
      (:NEW.isbn, l_akcja, SYSDATE, USER, NULL,
       :OLD.tytul, :OLD.opis, :OLD.autor,
       :OLD.data_wydania, :OLD.liczba_stron,
       :NEW.tytul, :NEW.opis, :NEW.autor,
       :NEW.data_wydania, :NEW.liczba_stron);
END;
/

SHOW ERRORS

