REM $Id: webu.pkb,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 9

REM Ciao wersji z rozdziau 9 pakietu web utilities (webu), w ktrej dodano
REM funkcje zabezpieczajce

SET DEFINE OFF
CREATE OR REPLACE PACKAGE BODY webu AS

   FUNCTION mies_lista_opcji(selected_mies IN VARCHAR2)
      RETURN VARCHAR2
   IS
      seltekst VARCHAR2(10);
      lista VARCHAR2(512) := '<OPTION value="">(Mie)';
      selected_miesiac_indeks PLS_INTEGER;
      mies VARCHAR2(3);
   BEGIN

      BEGIN
         selected_miesiac_indeks :=
            TO_CHAR(TO_DATE(UPPER(selected_mies), 'MON'), 'MM');
      EXCEPTION
      WHEN OTHERS THEN
         selected_miesiac_indeks := 1;
      END;
 
      FOR m_num IN 1..12
      LOOP
         IF selected_miesiac_indeks = m_num
         THEN
            seltekst := ' SELECTED ';
         ELSE
            seltekst := ' ';
         END IF;
         mies := TO_CHAR(TO_DATE(m_num, 'MM'),'MON');
         lista := lista || '<OPTION' || seltekst || 'value="' || mies
            || '">' || INITCAP(mies) || nopu.koniec_wiersza;
      END LOOP;

      RETURN lista;
   END;
      
   FUNCTION dd_lista_opcji(selected_dd IN VARCHAR2)
      RETURN VARCHAR2
   IS
      seltekst VARCHAR2(10);
      lista VARCHAR2(768) := '<OPTION value="">(dzie)';
      selected_integer PLS_INTEGER;
   BEGIN

      BEGIN
         selected_integer := TO_NUMBER(selected_dd);
      EXCEPTION
         WHEN OTHERS
         THEN
            selected_integer := 1;
      END;

      FOR dd_num IN 1..31
      LOOP
         IF selected_integer = dd_num
         THEN
            seltekst := ' SELECTED ';
         ELSE
            seltekst := ' ';
         END IF;
         lista := lista || '<OPTION' || seltekst || 'value="' ||
            TO_CHAR(dd_num, 'FM09') || '">' || TO_CHAR(dd_num) || nopu.koniec_wiersza;
      END LOOP;

      RETURN lista;
   END;

   FUNCTION esc_tekst(tekst IN VARCHAR2)
      RETURN VARCHAR2
   IS
   BEGIN
      RETURN REPLACE(REPLACE(tekst, CHR(10), '<BR>'),' ','&nbsp;');
   END;

   FUNCTION errfont(tekst IN VARCHAR2)
      RETURN VARCHAR2
   IS
   BEGIN
      RETURN ('<FONT color="red">' || tekst || '</FONT>');
   END;

   PROCEDURE drukujerr(tekst IN VARCHAR2)
   IS
   BEGIN
      HTP.P('<P>' || errfont(HTF.ESCAPE_SC(tekst)) || '</P>');
   END;

   PROCEDURE drukujinfo(tekst IN VARCHAR2)
   IS
   BEGIN
      HTP.P('<P><I><FONT color="green">'
            || HTF.ESCAPE_SC(tekst)
            || '</FONT></I></P>');
   END;

   PROCEDURE przekieruj (url_in IN VARCHAR2)
   IS
      znacznik VARCHAR2(1);
   BEGIN
      IF url_in IS NULL
      THEN
         RETURN;
      ELSE
         OWA_UTIL.REDIRECT_URL(url_in);

         /* Alternatywna metoda -- potencjalnie mniej bezpieczna?
         | HTP.INIT;
         | EXECUTE IMMEDIATE 'BEGIN ' 
         |  || cel_ ');'
         |  || 'END;';
         */
      END IF;
   END przekieruj;

   PROCEDURE odswiez (url_in IN VARCHAR2,
      tekst_body IN VARCHAR2,
      opozn_sekundy IN PLS_INTEGER DEFAULT 5)
   IS
   BEGIN
      HTP.INIT;
      HTP.P('<HTML>
         <HEAD>
            <META http-equiv="refresh" content="'
               || opozn_sekundy
               || ';URL=' || url_in || '">' || '
            <TITLE>Przepraszamy</TITLE>
         </HEAD>
      <BODY>');
      HTP.P(tekst_body);
      HTP.P('</BODY>
         </HTML>
         ');
   END odswiez;

END;
/

SHOW ERRORS
SET DEFINE ON

