REM $Id: nopu.pkb,v 1.1 2001/11/30 23:20:19 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 4

REM Ciao pakietu zawierajcego najbardziej oglne narzdzia uywane
REM w ksice.  "nopu" = Nauka Oracle PL/SQL Utilities.

CREATE OR REPLACE PACKAGE BODY nopu
AS

   dflt_date_format_private nls_session_parameters.value%TYPE;

   PROCEDURE ustaw_dflt_date_format(format_daty IN VARCHAR2)
   IS
   BEGIN
      dflt_date_format_private := format_daty;
   END;

   FUNCTION dflt_date_format
      RETURN VARCHAR2
   IS
   BEGIN
      RETURN dflt_date_format_private;
   END;

   FUNCTION czy_lancuch (cos IN VARCHAR2)
      RETURN BOOLEAN
   IS
   BEGIN
      RETURN TRUE;
   END;

   FUNCTION czy_number (cos IN VARCHAR2)
      RETURN BOOLEAN
   IS
      testerliczby NUMBER;
   BEGIN
      testerliczby := TO_NUMBER(cos);
      RETURN TRUE;
   EXCEPTION
      WHEN OTHERS
      THEN
         RETURN FALSE;
   END;

   FUNCTION czy_data (cos IN VARCHAR2,
      format_daty IN VARCHAR2 DEFAULT dflt_date_format)
      RETURN BOOLEAN
   IS
      testerdaty DATE;
   BEGIN
      testerdaty := TO_DATE(cos, format_daty);
      RETURN TRUE;
   EXCEPTION
      WHEN OTHERS
      THEN
         RETURN FALSE;
   END;

   FUNCTION lanc_pasuje (cos IN VARCHAR2,
      min_dlugosc IN NUMBER,
      max_dlugosc IN NUMBER)
      RETURN BOOLEAN
   IS
      dlugosc_cos NUMBER := LENGTH(cos);
   BEGIN
      IF (cos IS NULL AND min_dlugosc = 0)
         OR
            (dlugosc_cos >= min_dlugosc
            AND
            dlugosc_cos <= max_dlugosc)
      THEN
         RETURN TRUE;
      ELSE
         RETURN FALSE;
      END IF;
   END lanc_pasuje;

BEGIN

   /* Ta sekcja pakietu jest wykonywana automatycznie, gdy wywoywana jest
   || po raz pierwszy ktra cz pakietu.  Mona uy jej wic do
   || inicjalizowania zmiennych.  (Patrz strona 321.)
   */

   SELECT VALUE INTO dflt_date_format_private
     FROM NLS_SESSION_PARAMETERS
    WHERE PARAMETER = 'NLS_DATE_FORMAT';

EXCEPTION
   WHEN OTHERS
   THEN NULL;

END nopu;
/

SHOW ERRORS

