REM $Id$
REM Z "Nauka Oracle PL/SQL" strona 274

REM Wyzwalacz sucy do wysyanis wiadomoci elektronicznej do czytelnika, kiedy
REM egzemplarz ksiki, jak zarezerwowa zosta zwrcony do biblioteki

CREATE OR REPLACE TRIGGER ksiazka_trans_trg
   AFTER INSERT
   ON czytelnik_egz_ks_zdarzenia
   FOR EACH ROW
DECLARE
   CURSOR ucur
   IS
      SELECT ckr.id_czytelnika, ckr.data_wpisania,
             k.tytul, ub.adres_email, ub.nazwa_uzytk
        FROM egzemplarze_ksiazki ek,
             ksiazki k,
             czytelnik_ksiazka_rezerwacje ckr,
             uzytk_bibl ub
       WHERE ek.isbn = ckr.isbn
         AND ek.id_kodu_kresk = :NEW.id_kodu_kresk
         AND ckr.data_powiadomienia IS NULL         
         AND ub.id = ckr.id_czytelnika
         AND k.isbn = ek.isbn
       ORDER BY data_wpisania
         FOR UPDATE OF ckr.data_powiadomienia;

   urec ucur%ROWTYPE;

BEGIN
   IF :NEW.nazwa_zdarzenia = 'oddanie'
   THEN
      OPEN ucur;
      FETCH ucur INTO urec;
      IF ucur%FOUND
      THEN
         nopu.wyslij_email(nadawca_email => 'oracle@mydomain.com',
                  adresat_email => urec.adres_email,
                  temat => 'Zarezerwowana ksika jest ju dostpna',
                  tresc => 'Biblioteka posiada egzemplarz '
                              || urec.tytul || ' do odebrania.',
                  nazwa_adresata => urec.nazwa_uzytk);
         UPDATE czytelnik_ksiazka_rezerwacje
            SET data_powiadomienia = SYSDATE
          WHERE CURRENT OF ucur;
      END IF;
      CLOSE ucur;
   END IF;
END;
/

SHOW ERRORS

