REM $Id: exc.pkb,v 1.1 2001/11/30 23:19:50 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 319

REM Ciao pakietu wspomagajcego obsug wyjtkw uytego pierwszy raz
REM w ciele pakietu "ksiazka" w Rozdziale 5

CREATE OR REPLACE PACKAGE BODY exc
AS

   TYPE error_tekst_t IS TABLE OF VARCHAR2(512) INDEX BY BINARY_INTEGER;
   error_teksty error_tekst_t;

   PROCEDURE mojeraise (exc_no IN PLS_INTEGER, tekst IN VARCHAR2)
   IS
   BEGIN
      nopu.okresl_nie_null(exc_no,
         'bd programu: exc.mojeraise wywoano z exc_no o wartoci NULL');
      IF tekst IS NULL AND error_teksty.EXISTS(exc_no)
      THEN
         RAISE_APPLICATION_ERROR(exc_no,
            'Bd: ' || error_teksty(exc_no));
      ELSE
         RAISE_APPLICATION_ERROR(exc_no, tekst);
      END IF;
   END;

BEGIN

   /* Domylne komunikaty o bdach. */

   error_teksty(wymagana_autoryzacja_cd) :=
      'Brak uprawnie dla wykonania wymaganej operacji.';

   error_teksty(brak_implementacji_funkcji_cd) :=
      'Funkcja nie zaimplementowana. Naley zmobilizowa programist.';

   error_teksty(brak_wartosci_cd) :=
      'Brak wartoci. Wypenij wszystkie pola.';

   error_teksty(sesja_zakonczona_cd) :=
      'Sesja zkoczona. Zaloguj si ponownie.';

   error_teksty(nie_zalogowany_cd) :=
      'Podaj prawidow nazw uytkownika i haso.';

   error_teksty(blad_formatu_danych_cd) :=
      'Podane przez uytkownika dane nie s w oczekiwanym formacie.';

   error_teksty(niedozw_zmiana_niepowt_id_cd) :=
      'Zmiana niepowtarzalnego identyfikatora nie jest dozwolona w tej aplikacji.';

   error_teksty(prob_z_wyslaniem_mail_cd) :=
      'Pojawi si problem podczas prby wysania wiadomoci email.';

   error_teksty(nie_pobrano_odleglego_url_cd) :=
      'Prba pobrania odlegej strony WWW zakoczona niepowodzeniem.';
END;
/

SHOW ERRORS

