REM $Id: test_ilosc_egzemp_ksiazki.sql,v 1.1 2001/11/30 23:09:49 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 88

REM Wersja z anonimowym blokiem programu testujcego funkcj ilosc_egzemp_ksiazki

DECLARE
   l_isbn VARCHAR2(13) := '1-56592-335-9';
   l_isbn2 VARCHAR2(13) := '2-56592-335-9';
   l_tytul VARCHAR2(200) := 'Programowanie w Oracle PL/SQL';
   l_opis VARCHAR2(2000) := 'Podrcznik encyklopedyczny dla programistw PL/SQL, ' ||
       'wraz z przykadami i wskazwkami na temat programowania.';
   l_autor varchar2(200) := 'Feuerstein, Steven, Bill Pribyl';
   l_data_wydania DATE := TO_DATE('01-WRZ-1997', 'DD-MON-YYYY');
   l_liczba_stron NUMBER := 987;
   l_id_kodu_kresk VARCHAR2(100) := '100000001';
   l_id_kodu_kresk2 VARCHAR2(100) := '100000002';
   l_id_kodu_kresk3 VARCHAR2(100) := '100000003';

   ile NUMBER;
BEGIN
   DELETE egzemplarze_ksiazki;
   DELETE ksiazki;

   testrownosci('funkcja ilosc_egzemp_ksiazki, brak rekordw', '0',
      TO_CHAR(ilosc_egzemp_ksiazki(l_isbn)));

   /* Zakadamy, e procedura dodaj_ksiazke dziaa poprawnie */
   dodaj_ksiazke(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk,
      tytul_in => l_tytul, opis_in => l_opis, autor_in => l_autor,
      data_wydania_in => l_data_wydania, liczba_stron_in => l_liczba_stron);

   testrownosci('funkcja ilosc_egzemp_ksiazki, jeden rekord', '1',
      TO_CHAR(ilosc_egzemp_ksiazki(l_isbn)));

   dodaj_egzemp_ksiazki(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk2);
   dodaj_egzemp_ksiazki(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk3);

   testrownosci('funkcja ilosc_egzemp_ksiazki, wiele rekordw', '3',
      TO_CHAR(ilosc_egzemp_ksiazki(l_isbn)));

   testrownosci('funkcja ilosc_egzemp_ksiazki, ISBN o wartoci NULL', '0',
      TO_CHAR(ilosc_egzemp_ksiazki(NULL)));
END;
/

