REM $Id: loginweb.pkb,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 345

REM Ciao pakietu, ktry obsuguje zagadnienia interfejsu uytkownika
REM zwizane z logowaniem si do systemu opartego na sieci web

CREATE OR REPLACE PACKAGE BODY loginweb
AS

   PROCEDURE login_proces(nazwa_uzytk_ IN VARCHAR2,
      zwyklytekst_haslo_ IN VARCHAR2,
      cel_ IN VARCHAR2,
      wyslij IN VARCHAR2)
   IS
      idsesji web_sesje.id%TYPE;
      znacznik VARCHAR2(1) := '&';
   BEGIN
      /* asercje wartoci rnych od NULL okrelone w wywoaniu funkcji id_nowej_sesji */
      idsesji := 
         uprawnweb.id_nowej_sesji(nazwa_uzytk_, zwyklytekst_haslo_);

      IF cel_ IS NULL
      THEN
         HTP.INIT;
         ksiazkaszukanie;
      ELSE
         IF INSTR(cel_, '?') = 0
         THEN
            znacznik := '?';
         END IF;
         webu.przekieruj(cel_ || znacznik || 'id_sesji_=' || idsesji);
      END IF;

   END login_proces;


   PROCEDURE logout (id_sesji_ web_sesje.id%TYPE,
      cel_ IN VARCHAR2)
   IS
   BEGIN
      IF id_sesji_ IS NOT NULL
      THEN
         DELETE web_sesje WHERE id = id_sesji_;
      END IF;
      webu.przekieruj(cel_);
   END logout;

END loginweb;
/

SHOW ERRORS

