REM $Id$ wyslij_email.pro
REM Z "Nauka Oracle PL/SQL" strona 269

REM Jest to procedura wyslij_email, ktra wystpuje take w pakiecie nopu, a zostaa
REM wydzielona tylko dla wygody

CREATE OR REPLACE PROCEDURE wyslij_email
   (nadawca_email IN VARCHAR2, 
   adresat_email IN VARCHAR2, 
   tresc IN VARCHAR2,
   temat IN VARCHAR2 DEFAULT NULL,
   nazwa_nadawcy IN VARCHAR2 DEFAULT NULL,
   nazwa_adresata IN VARCHAR2 DEFAULT NULL,
   mailhost IN VARCHAR2 DEFAULT 'mailhost')
IS
   mail_conn  UTL_SMTP.CONNECTION;
   rezultat UTL_SMTP.REPLY;
   smtp_tcpip_port CONSTANT PLS_INTEGER := 25;
   crlf CONSTANT VARCHAR2(2) := CHR(13) || CHR(10);
   okay_c CONSTANT PLS_INTEGER := 250;
   closed_c CONSTANT PLS_INTEGER := 221;
   gotow_na_dane_c CONSTANT PLS_INTEGER := 354;

   PROCEDURE sprpowtorz (rezultat IN UTL_SMTP.REPLY, oczekiwany_kod IN PLS_INTEGER)
   IS
   BEGIN
      nopu.okresl(warunek_in => rezultat.CODE = oczekiwany_kod,
                  komunikat_in => rezultat.CODE || ' ' || rezultat.TEXT,
                  wyjatek_in => exc.prob_z_wyslaniem_mail_cd);
   END;

BEGIN
   mail_conn := UTL_SMTP.OPEN_CONNECTION(mailhost, smtp_tcpip_port);

   sprpowtorz( UTL_SMTP.HELO(mail_conn, mailhost), okay_c);
   sprpowtorz( UTL_SMTP.MAIL(mail_conn, nadawca_email), okay_c);
   sprpowtorz( UTL_SMTP.RCPT(mail_conn, adresat_email), okay_c);
   sprpowtorz( UTL_SMTP.OPEN_DATA(mail_conn), gotow_na_dane_c);

   UTL_SMTP.WRITE_DATA(mail_conn,
      'Data: '
         || TO_CHAR(CURRENT_TIMESTAMP, 'Dy, dd Mon YYYY HH24:MI:SS TZHTZM')
         || crlf);
   UTL_SMTP.WRITE_DATA(mail_conn,
       'Od: ' || nazwa_nadawcy || ' <' || nadawca_email || '>' || crlf);
   UTL_SMTP.WRITE_DATA(mail_conn,
       'Temat: ' || temat || crlf);
   UTL_SMTP.WRITE_DATA(mail_conn,
       'Do: ' || nazwa_adresata || ' <' || adresat_email || '>' || crlf);
   UTL_SMTP.WRITE_DATA(mail_conn, tresc);

   sprpowtorz( UTL_SMTP.CLOSE_DATA(mail_conn), okay_c);
   sprpowtorz( UTL_SMTP.QUIT(mail_conn), closed_c);

EXCEPTION
   WHEN OTHERS
   THEN
      exc.mojeraise(exc.prob_z_wyslaniem_mail_cd, SQLERRM);
END;
/

