REM $Id: tut.pkb,v 1.1 2001/11/30 23:09:49 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 3

REM Ciao pakietu narzdzi testujcych (nie pojawia si w ksice; 
REM pozostawione jako "wiczenie dla Czytelnika")

CREATE OR REPLACE PACKAGE BODY tut
AS
   PROCEDURE testrownosci (opis IN VARCHAR2,
      wartosc_oczekiwana IN VARCHAR2, wartosc_otrzymana IN VARCHAR2)
   IS
   BEGIN
      DBMS_OUTPUT.PUT(opis || ': ');
      IF wartosc_oczekiwana = wartosc_otrzymana
         OR (wartosc_oczekiwana IS NULL AND wartosc_otrzymana IS NULL)
      THEN
         DBMS_OUTPUT.PUT_LINE('SUKCES');
      ELSE
         DBMS_OUTPUT.PUT_LINE('BD.  Oczekiwano ' || wartosc_oczekiwana 
            || '; otrzymano ' || wartosc_otrzymana);
      END IF;
   END;

   PROCEDURE testrownosci (opis IN VARCHAR2,
      wartosc_oczekiwana IN NUMBER, wartosc_otrzymana IN NUMBER)
   IS
   BEGIN
      testrownosci(opis, TO_CHAR(wartosc_oczekiwana), TO_CHAR(wartosc_otrzymana));
   END;

   PROCEDURE testrownosci (opis IN VARCHAR2,
      wartosc_oczekiwana IN BOOLEAN, wartosc_otrzymana IN BOOLEAN)
   IS
   BEGIN
      testrownosci(opis, booleantochar(wartosc_oczekiwana),
               booleantochar(wartosc_otrzymana));
   END;

   PROCEDURE testrownosci (opis IN VARCHAR2,
      wartosc_oczekiwana IN DATE, wartosc_otrzymana IN DATE)
   IS
   BEGIN
      testrownosci(opis, TO_CHAR(wartosc_oczekiwana, 'YYYY-MON-DD HH24:MI:SS'),
               TO_CHAR(wartosc_otrzymana, 'YYYY-MON-DD HH24:MI:SS'));
   END;

END;
/

SHOW ERRORS

