-- Ten skrypt uruchomi si tylko w Oracle Database 10g lub nowszej

-- Ten skrypt:
--   1. Tworzy uytkownika lob_user2
--   2. Tworzy tebele i wypenia je danymi
--   3. Tworzy kod PL/SQL 

-- Usunicie uytkownika lob_user2 jeeli istnieje.
-- To polecenie moe zwrci bd jeli uytkownik nie istnieje; nie naley si tym przejmowa.
DROP USER lob_user2 CASCADE;

-- utworzenie uytkownika lob_user2
CREATE USER lob_user2 IDENTIFIED BY lob_password2;

-- nadanie uytkownikowi uprawnie do czenia si i tworzenia obiektw bazy danych
GRANT connect, resource TO lob_user2;

-- przydzielenie uytkownikowi miejsca w przestrzeni tabel users
ALTER USER lob_user2 QUOTA 10M ON users;

-- poczenie jako uytkownik lob_user2
CONNECT lob_user2/lob_password2;

-- tworzenie tabel 

-- przykad niejawnej konwersji midzy obiektami CLOB i NCLOB 
CREATE TABLE nclob_content (
  id INTEGER PRIMARY KEY,
  nclob_column NCLOB
);

CREATE TABLE clob_content (
  id INTEGER PRIMARY KEY,
  clob_column CLOB
);

INSERT INTO clob_content (
  id, clob_column
) VALUES (
  1, TO_CLOB('Wije si w ciasnym kku')
);

INSERT INTO clob_content (
  id, clob_column
) VALUES (
  2, TO_CLOB(' od dnia do dnia ')
);


CREATE OR REPLACE PROCEDURE nclob_example
AS
  clob_var CLOB := 'To jest tekst CLOB';
  nclob_var NCLOB;
BEGIN
  -- wstawia clob_var do nclob_column 
  INSERT INTO nclob_content (
    id, nclob_column
  ) VALUES (
    1, clob_var
  );

  -- wybiera nclob_column do clob_var 
  SELECT nclob_column
  INTO clob_var
  FROM nclob_content
  WHERE id = 1;

  -- wywietla zawarto CLOB
  DBMS_OUTPUT.PUT_LINE('clob_var = ' || clob_var);
END nclob_example;
/

-- uycie atrybutu :new gdy obiekt LOB jest uywany w wyzwalaczu BEFORE UPDATE 
CREATE OR REPLACE TRIGGER before_clob_content_update
BEFORE UPDATE
ON clob_content
FOR EACH ROW
BEGIN
  DBMS_OUTPUT.PUT_LINE('zawarto clob_content zostaa zmieniona');
  DBMS_OUTPUT.PUT_LINE(
    'Dugo = ' || DBMS_LOB.GETLENGTH(:new.clob_column)
  );
END before_clob_content_update;
/

-- commit the transaction
COMMIT;
