-- Ten skrypt tworzy dwie procedury PL/SQL. Naley go wykona z konta uytkownika store.

CREATE OR REPLACE PROCEDURE write_xml_data_to_file(
  p_directory VARCHAR2,
  p_file_name VARCHAR2
) AS
  v_file UTL_FILE.FILE_TYPE;
  v_amount INTEGER := 32767;
  v_xml_data XMLType;
  v_char_buffer VARCHAR2(32767);
BEGIN
  -- otwiera plik do zapisu tekstu (maks. v_amount
  -- znakw w operacji)
  v_file := UTL_FILE.FOPEN(p_directory, p_file_name, 'w', v_amount);

  -- zapisuje pocztkowy wiersz do v_file
  UTL_FILE.PUT_LINE(v_file, '<?xml version="1.0"?>');

  -- pobiera inf. o klientach i zapisuje je w v_xml_data
  SELECT
    EXTRACT(
      XMLELEMENT(
        "customer_list",
        XMLAGG(
          XMLELEMENT("customer", first_name || ' ' || last_name)
          ORDER BY last_name
        )
      ),
    '/customer_list'
  )
AS xml_customers
INTO v_xml_data
FROM customers;
-- get the string value from v_xml_data and store it in v_char_buffer
v_char_buffer := v_xml_data.GETSTRINGVAL();
-- copy the characters from v_char_buffer to the file
UTL_FILE.PUT(v_file, v_char_buffer);
-- flush any remaining data to the file
UTL_FILE.FFLUSH(v_file);
-- close the file
UTL_FILE.FCLOSE(v_file);
END write_xml_data_to_file;
/

CREATE OR REPLACE PROCEDURE create_xml_resources AS
  v_result BOOLEAN;

  -- tworzy napis zawierajcy XML dla produktw
  v_products VARCHAR2(300):=
    '<?xml version="1.0"?>' ||
    '<products>' ||
      '<product product_id="1" product_type_id="1" name="Nauka Wspczesna"'
      || ' price="19,95"/>' ||
      '<product product_id="2" product_type_id="1" name="Chemia"' ||
      ' price="30"/>' ||
      '<product product_id="3" product_type_id="2" name="Supernowa"' ||
      ' price="25,99"/>' ||
  '</products>';

  -- tworzy napis zawierajcy XML dla typw produktw
  v_product_types VARCHAR2(300):=
  '<?xml version="1.0"?>' ||
  '<product_types>' ||
    '<product_type product_type_id="1" name="Ksika"/>' ||
    '<product_type product_type_id="2" name="Film"/>' ||
  '</product_types>';
BEGIN

  -- tworzy zasb dla produktw
  v_result := DBMS_XDB.CREATERESOURCE('/public/products.xml',
    v_products);

  -- tworzy zasb dla typw produktw
  v_result := DBMS_XDB.CREATERESOURCE('/public/product_types.xml',
    v_product_types);
END create_xml_resources;
/
