-- Ten skrypt SQL*Plus (collection_schema2.sql):
--   1. Tworzy uytkownika collection_user2
--   2. Tworzy baz danych
--   3. Wypenia baz danych przykadowymi danymi
--   4. Tworzy kod PL/SQL

-- usunicie uytkownika collection_user2 jeeli istnieje.
-- To polecenie moe zwrci bd jeli uytkownik nie istnieje; nie naley si tym przejmowa.
DROP USER collection_user2 CASCADE;

-- utworzenie uytkownika collection_user2
CREATE USER collection_user2 IDENTIFIED BY collection_password;

-- nadanie uprawnie uytkownikowi collection_user2 do czenia i tworzenia obiektw bazy danych
GRANT connect, resource, create public synonym TO collection_user2;

-- przydzielenie uytkownikowi miejsca w przestrzeni tabel users
ALTER USER collection_user2 QUOTA 10M ON users;

-- poczenie jako uytkownik collection_user2
CONNECT collection_user2/collection_password;

-- tworzenie obiektw i kolekcji
CREATE TYPE t_varray_phone AS VARRAY(3) OF VARCHAR2(14);
/

CREATE TYPE t_address AS OBJECT (
  street        VARCHAR2(15),
  city          VARCHAR2(15),
  state         CHAR(3),
  zip           VARCHAR2(5),
  phone_numbers t_varray_phone
);
/

CREATE TYPE t_nested_table_address AS TABLE OF t_address;
/


-- tworzenie tabel

CREATE TABLE customers_with_nested_table (
  id         INTEGER PRIMARY KEY,
  first_name VARCHAR2(10),
  last_name  VARCHAR2(10),
  addresses  t_nested_table_address
)
NESTED TABLE
  addresses
STORE AS
  nested_addresses;


-- dodanie przykadowych danych do tabeli customers_with_nested_table 

INSERT INTO customers_with_nested_table VALUES (
  1, 'Stefan', 'Brzowy',
  t_nested_table_address(
    t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345',
      t_varray_phone(
        '(22)-555-1211',
        '(22)-555-1212',
        '(22)-555-1213'
      )
    ),
    t_address('Wysoka 4', 'Skomilice', 'MA', '54321',
      t_varray_phone(
        '(12)-555-1211',
        '(12)-555-1212'
      )
    )
  )
);

-- zatwierdzenie transakcji
COMMIT;
