/* ================================================================
||   Program: expanding_view.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   11
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Wymaga uruchomienia programu generującego dane.
|| ================================================================*/

CREATE OR REPLACE group_view AS
  SELECT   cr.full_name
  FROM     member m INNER JOIN current_rental cr
  ON       m.account_number = cr.account_number
  WHERE    m.member_type =
            (SELECT   common_lookup_id
             FROM     common_lookup
             WHERE    common_lookup_type = 'GROUP');

-- Przekształca kolumnę typu LONG na typ CLOB.
CREATE OR REPLACE FUNCTION long_to_clob
( pv_view_name      VARCHAR2
, pv_column_length  INTEGER )
RETURN CLOB AS

  /* Deklaracje zmiennych lokalnych. */
  lv_cursor    INTEGER := dbms_sql.open_cursor;
  lv_feedback  INTEGER;         -- Potwierdzenie wykonania dynamicznej instrukcji
  lv_length    INTEGER;         -- Długość łańcucha znaków
  lv_return    CLOB;            -- Wartość zwracana przez funkcję
  lv_stmt      VARCHAR2(2000);  -- Dynamiczna instrukcja SQL-a
  lv_string    VARCHAR2(32760); -- Maksymalna długość typu LONG

BEGIN
  /* Tworzenie dynamicznej instrukcji. */
  lv_stmt := 'SELECT text'||CHR(10)
          || 'FROM user_views'||CHR(10)
          || 'WHERE view_name = '''||pv_view_name||'''';

  /* Parsowanie instrukcji i definiowanie kolumny typu LONG. */
  dbms_sql.parse(lv_cursor, lv_stmt, dbms_sql.native);
  dbms_sql.define_column_long(lv_cursor,1);

  /* Próba przetwarzania następuje tylko po pobraniu danych. */
  IF dbms_sql.execute_and_fetch(lv_cursor) = 1 THEN
    dbms_sql.column_value_long(
        lv_cursor
      , 1
      , pv_column_length
      , 0
      , lv_string
      , lv_length);
  END IF;

  /* Sprawdzanie, czy kursor nie jest otwarty. */
  IF dbms_sql.is_open(lv_cursor) THEN
    dbms_sql.close_cursor(lv_cursor);
  END IF;

  /* Tworzenie w pamięci lokalnego tymczasowego obiektu typu CLOB:
     - Zwraca zmienną lv_return_result.
     - Unieważnia wersję z pamięci podręcznej.
     - Ustawia czas trwania na 12 (jest to wartość stałej dbms_lob.call
       z poziomu pakietu; wartość domyślna to 10). */
  dbms_lob.createtemporary(lv_return, FALSE, dbms_lob.call);

  /* Dodawanie wartości typu LONG do pustego tymczasowego obiektu typu CLOB. */
  dbms_lob.write(lv_return, pv_column_length, 1, lv_string);

  RETURN lv_return;
END long_to_clob;
/

-- Tworzenie funkcji używającej procedury dbms_utility.expand_sql_text.
CREATE OR REPLACE FUNCTION expand_view 
( pv_view_name  VARCHAR2 ) RETURN CLOB IS

  /* Deklaracje zmiennych na widoki. */
  lv_input_view   CLOB;
  lv_output_view  CLOB;

  /* Deklaracja zmiennej docelowej (potrzebna z powodu ograniczeń instrukcji SELECT-INTO). */
  lv_long_view  LONG;

  /* Deklaracja kursora dynamicznego. */
  CURSOR c (cv_view_name VARCHAR2) IS
    SELECT   text
    FROM     user_views
    WHERE    view_name = cv_view_name;
 
BEGIN
  /* Otwieranie kursora, pobieranie danych (tekstu widoku) i zamykanie kursora. */
  OPEN c(pv_view_name);
  FETCH c INTO lv_long_view;
  CLOSE c;

  /* Przekształcanie zwracanej wartości typu LONG na typ CLOB. */
  lv_input_view := long_to_clob(pv_view_name, LENGTH(lv_long_view));

  /* Przekazywanie tekstu widoku i pobieranie kompletnego tekstu. */
  dbms_utility.expand_sql_text(lv_input_view, lv_output_view);

  /* Zwracanie wyjściowego obiektu typu CLOB. */
  RETURN lv_output_view;
END;
/

-- Przekształca kolumnę typu LONG na typ VARCHAR2.
CREATE OR REPLACE FUNCTION long_to_varchar2
( pv_view_name      VARCHAR2
, pv_column_length  INTEGER )
RETURN VARCHAR2 AS

  /* Deklaracje zmiennych lokalnych. */
  lv_cursor    INTEGER := dbms_sql.open_cursor;
  lv_feedback  INTEGER;          -- Potwierdzenie wykonania dynamicznej instrukcji
  lv_length    INTEGER;          -- Długość łańcucha znaków
  lv_return    VARCHAR2(32767);  -- Wartość zwracana przez funkcję
  lv_stmt      VARCHAR2(2000);   -- Dynamiczna instrukcja SQL-a
  lv_string    VARCHAR2(32760);  -- Maksymalna długość typu LONG

BEGIN
  /* Tworzenie dynamicznej instrukcji. */
  lv_stmt := 'SELECT text'||CHR(10)
          || 'FROM user_views'||CHR(10)
          || 'WHERE view_name = '''||pv_view_name||'''';

  /* Parsowanie instrukcji i definiowanie kolumny typu LONG. */
  dbms_sql.parse(lv_cursor, lv_stmt, dbms_sql.native);
  dbms_sql.define_column_long(lv_cursor,1);

  /* Próba przetwarzania ma miejsce tylko po pobraniu wartości. */
  IF dbms_sql.execute_and_fetch(lv_cursor) = 1 THEN
    dbms_sql.column_value_long(
        lv_cursor
      , 1
      , pv_column_length
      , 0
      , lv_string
      , lv_length);
  END IF;

  /* Sprawdzanie, czy kursor nie jest otwarty. */
  IF dbms_sql.is_open(lv_cursor) THEN
    dbms_sql.close_cursor(lv_cursor);
  END IF;

  /* Ustawianie maksymalnej długości typu LONG. */
  lv_return := lv_string;

  RETURN lv_return;
END long_to_varchar2;
/

-- Tworzenie funkcji używającej procedury dbms_utility.expand_sql_text.
CREATE OR REPLACE FUNCTION expand_view 
( pv_view_name  VARCHAR2 ) RETURN CLOB IS

  /* Deklaracje zmiennych na widoki. */
  lv_input_view   CLOB;
  lv_output_view  CLOB;

  /* Deklaracja docelowej zmiennej (potrzebna z powodu ograniczeń instrukcji SELECT-INTO). */
  lv_long_view  LONG;

  /* Deklaracja kursora dynamicznego. */
  CURSOR c (cv_view_name VARCHAR2) IS
    SELECT   text
    FROM     user_views
    WHERE    view_name = cv_view_name;
 
BEGIN
  /* Otwieranie kursora, pobieranie danych (tekstu widoku) i zamykanie kursora. */
  OPEN c(pv_view_name);
  FETCH c INTO lv_long_view;
  CLOSE c;

  /* Przekształcanie wartości typu LONG na typ CLOB. */
  lv_input_view := long_to_clob(pv_view_name, LENGTH(lv_long_view));

  /* Przekazywanie tekstu widoku i pobieranie kompletnego tekstu. */
  dbms_utility.expand_sql_text(lv_input_view, lv_output_view);

  /* Zwracanie wartości typu CLOB. */
  RETURN lv_output_view;
END;
/

-- Funkcja zwracająca tekst widoku.
CREATE OR REPLACE FUNCTION return_view_text 
( pv_view_name  VARCHAR2 ) RETURN VARCHAR2 IS

  /* Deklaracja docelowej zmiennej (potrzebna z powodu ograniczeń instrukcji SELECT-INTO). */
  lv_long_view  LONG;

  /* Deklaracja kursora dynamicznego. */
  CURSOR c (cv_view_name VARCHAR2) IS
    SELECT   text
    FROM     user_views
    WHERE    view_name = cv_view_name;
 
BEGIN
  /* Otwieranie kursora, pobieranie danych (tekstu widoku) i zamykanie kursora. */
  OPEN c(pv_view_name);
  FETCH c INTO lv_long_view;
  CLOSE c;

  /* Zwracanie wartości typu CLOB. */
  RETURN long_to_varchar2(pv_view_name, LENGTH(lv_long_view));
END;
/

-- Test funkcji expand_view.
SELECT expand_view('GROUP_RENTAL') FROM dual;
