/* ================================================================
||   Program Name: result_cache.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje funkcje zapisujące wyniki w pamięci podręcznej.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE UNLIMITED

-- Tworzenie kolekcji łańcuchów znaków.
CREATE OR REPLACE TYPE strings AS TABLE OF VARCHAR2(60);
/

CREATE OR REPLACE FUNCTION get_title
( partial_title VARCHAR2 ) RETURN STRINGS
RESULT_CACHE RELIES_ON(item) IS
  -- Deklaracje zmiennych na licznik i kolekcję. 
  counter      NUMBER  := 1;
  return_value STRINGS := strings();

  -- Definicja kursora z parametrami.
  CURSOR get_title
  ( partial_title VARCHAR2 ) IS
  SELECT   item_title
  FROM     item
  WHERE    UPPER(item_title) LIKE '%'||UPPER(partial_title)||'%';
BEGIN
  -- Wczytywanie danych i zapisywanie ich do kolekcji w opartej na kursorze pętli FOR.
  FOR i IN get_title(partial_title) LOOP
    return_value.EXTEND;
    return_value(counter) := i.item_title;
    counter := counter + 1;
  END LOOP;
  RETURN return_value;
END get_title;
/

list
show errors

CREATE OR REPLACE FUNCTION get_common_lookup
( table_name VARCHAR2, column_name VARCHAR2 ) RETURN LOOKUP
RESULT_CACHE RELIES_ON(common_lookup) IS
  -- Zmienna lokalna zdefiniowanego przez użytkownika typu kolekcji.
  lookups LOOKUP;
 
  -- Kursor łączący kolumny w jeden łańcuch znaków z ogranicznikami.
  CURSOR c (table_name_in VARCHAR2, table_column_name_in VARCHAR2) IS
    SELECT   common_lookup_id||'|'||common_lookup_type||'|'||common_lookup_meaning
    FROM     common_lookup
    WHERE    common_lookup_table = UPPER(table_name_in)
    AND       common_lookup_column = UPPER(table_column_name_in);
BEGIN
  OPEN c(table_name, column_name);
  LOOP
    FETCH c BULK COLLECT INTO lookups;
    EXIT WHEN c%NOTFOUND;
  END LOOP;
  RETURN lookups;
END get_common_lookup;
/
DECLARE
  list STRINGS;
BEGIN
  list := get_title('Harry');
  FOR i IN 1..list.LAST LOOP
    dbms_output.put_line('list('||i||') : ['||list(i)||']');
  END LOOP;
END;
/
