/* ================================================================
||   Program: associative_array.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   6
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje tablice asocjacyjne.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED

DECLARE
  /* Definicja tablicy asocjacyjnej z wartościami skalarnymi. */
  TYPE suit_table IS TABLE OF VARCHAR2(7 CHAR)
    INDEX BY BINARY_INTEGER;

  /* Deklaracja i próba utworzenia obiektu. */
  lv_suit SUIT_TABLE;
BEGIN
  /* Przypisywanie wartości do kolekcji ADT. */
  lv_suit(1) := 'Trefl';
  lv_suit(2) := 'Kier';
  lv_suit(3) := 'Karo';
  lv_suit(4) := 'Pik';
  
  /* Przejście w pętli po kolekcji z indeksem gęstym. */
  FOR i IN lv_suit.FIRST..lv_suit.LAST LOOP
    dbms_output.put_line(lv_suit(i));
  END LOOP;
END;
/

DECLARE
  /* Zmienna o znaczącej nazwie. */
  current  VARCHAR2(11);
  
  /* Definicja tablicy asocjacyjnej z wartościami skalarnymi. */
  TYPE card_table IS TABLE OF NUMBER
    INDEX BY VARCHAR2(11);

  /* Deklaracja i próba utworzenia obiektu. */
  lv_card CARD_TABLE;
BEGIN
  /* Przypisywanie wartości do kolekcji ADT. */
  lv_card('Jeden') := 1;
  lv_card('Dwa') := 2;
  lv_card('Trzy') := 3;
  lv_card('Cztery') := 4;
  lv_card('Pięć') := 5;
  lv_card('Sześć') := 6;
  lv_card('Siedem') := 7;
  lv_card('Osiem') := 8;
  lv_card('Dziewięć') := 9;
  lv_card('Dziesięć') := 10;
  lv_card('Jedenaście') := 11;
  lv_card('Dwanaście') := 12;
  lv_card('Trzynaście') := 13;
  
  /* Ustawianie punktu początkowego. */
  current := lv_card.FIRST;
  
  /* Sprawdzanie wartości pseudoindeksu mniejszej od ostatniej. */
  WHILE (current <= lv_card.LAST) LOOP
    /* Wyświetlanie bieżącej wartości. */
    dbms_output.put_line(
      'Wartości ['||current||']['||lv_card(current)||']');

    /* Przesunięcie indeksu do następnej wartości. */
    current := lv_card.NEXT(current);    
  END LOOP;
END;
/

CREATE OR REPLACE
  TYPE prominent_object IS OBJECT
  ( name     VARCHAR2(20)
  , age      VARCHAR2(10));
/

DECLARE
  /* Deklaracja lokalnego złożonego typu danych SQL-a. */
  TYPE prominent_table IS TABLE OF prominent_object
    INDEX BY PLS_INTEGER;

  /* Deklaracja zmiennej lokalnej typu kolekcji. */
  lv_array  PROMINENT_TABLE;
BEGIN
  /* Indeks pierwszego elementu to -100. */
  lv_array(-100) := prominent_object('Bard the Bowman','3rd Age');

  /* Sprawdzanie, czy są dostępne elementy do pobrania. */
  IF lv_array.EXISTS(-100) THEN
    dbms_output.put_line(
      '['||lv_array(-100).name||']['||lv_array(-100).age||']');
  END IF;
END;
/

DECLARE
  /* Deklaracja lokalnego typu kolekcji z wartościami typu złożonego. */
  TYPE prominent_table IS TABLE OF prominent_object
    INDEX BY PLS_INTEGER;

  /* Deklaracja zmiennej lokalnej typu kolekcji. */
  lv_array  PROMINENT_TABLE;
BEGIN
  /* Indeks pierwszego elementu to -100. */
  lv_array(-100);

  /* Przypisywanie wartości do dwóch pól elementu. */
  lv_array(-100).name := 'Bard the Bowman';
  lv_array(-100).age  := '3rd Age';
  
  /* Sprawdzanie, czy są dostępne elementy do pobrania. */
  IF lv_array.EXISTS(-100) THEN
    dbms_output.put_line(
      '['||lv_array(-100).name||']['||lv_array(-100).age||']');
  END IF;
END;
/

DECLARE
  /* Deklaracja typu rekordowego. */
  TYPE prominent_record IS RECORD
  ( name     VARCHAR2(20)
  , age      VARCHAR2(10));

  /* Deklaracja lokalnego typu kolekcji z wartościami typu złożonego. */
  TYPE prominent_table IS TABLE OF prominent_record
    INDEX BY PLS_INTEGER;

  /* Deklaracja zmiennej lokalnej typu rekordowego. */
  lv_record  PROMINENT_RECORD;

  /* Deklaracja zmiennej lokalnej typu kolekcji. */
  lv_array   PROMINENT_TABLE;
BEGIN
  /* Indeks pierwszego elementu to -100. */
  lv_record.name := 'Bard the Bowman';
  lv_record.age  := '3rd Age';

  /* Przypisanie wartości rekordu do elementu kolekcji. */
  lv_array(-100) := lv_record;
  
  /* Sprawdzanie, czy są dostępne elementy do pobrania. */
  IF lv_array.EXISTS(-100) THEN
    dbms_output.put_line(
      '['||lv_array(-100).name||']['||lv_array(-100).age||']');
  END IF;
END;
/
