<html>
<! ================================================================>
<!   Program: UploadItemBlob.php                              >
<!   Data:      2013-07-25                                         >
<!   Książka:   Oracle Database 12c. Programowanie w języku PL/SQL >
<!   Rozdział:  10                                                 >
<!   Autor:  Michael McLaughlin                                    >
<! ---------------------------------------------------------------->
<!   Zawartość:                                                    >
<!   ---------                                                     >
<!   Ten skrypt ilustruje przesyłanie pliku, przenoszenie          >
<!   przesłanego pliku, zapisywanie danych w kolumnie typu CLOB    >
<!   za pomocą procedury składowanej języka PL/SQL, dostęp do      >
<!   danych zapisanych w bazie i wyświetlanie strony.              >
<! ================================================================>
<head>
<title>
  Rozdział 10. UploadItemBlob.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Wyświetlanie przeniesionego pliku na stronie.
  $item_blob = process_uploaded_file();

  // Próba nawiązania połączenia z bazą danych.
  if ($c = @oci_connect("plsql","plsql","orcl"))
  {
    // Deklaracja zmiennych wejściowych.
    (isset($_POST['id']))    ? $id = (int) $_POST['id'] : $id = 1021;
    (isset($_POST['title'])) ? $title = $_POST['title'] : $title = "Harry #1";

    // Deklaracja polecenia w języku PL/SQL.
    $stmt = "BEGIN
               web_load_blob_from_file(:id,:item_blob);
             END;";

    // Usuwanie znaków specjalnych w celu uniknięcia błędów ORA-06550 i PLS-00103.
    $stmt = strip_special_characters($stmt);

    // Parsowanie zapytania z wykorzystaniem połączenia.
    $s = oci_parse($c,$stmt);

    // Definiowanie deskryptora obiektu BLOB.
    $rlob = oci_new_descriptor($c,OCI_D_LOB);

    // Definiowanie zmiennej wiązanej z deskryptorem obiektu BLOB.
    oci_define_by_name($s,':item_blob',$rlob,SQLT_BLOB);

    // Wiązanie zmiennych języka PHP z typami OCI.
    oci_bind_by_name($s,':id',$id);
    oci_bind_by_name($s,':item_blob',$rlob,-1,SQLT_BLOB);

    // Wykonywanie instrukcji języka PL/SQL.
    if (oci_execute($s,OCI_DEFAULT))
    {

      $rlob->save($item_blob);
      oci_commit($c);
      oci_free_statement($s);
      query_insert($id,$title);
    }

    // Zamykanie połączenia z bazą.
    oci_close($c);
  }
  else
  {
    // Przypisywanie błędu OCI i formatowanie apostrofów oraz cudzysłowów.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }

  // Pobieranie wyników po wstawieniu danych.
  function query_insert($id,$title)
  {
    // Próba nawiązania połączenia z bazą.
    if ($c = @oci_new_connect("plsql","plsql","orcl"))
    {
      // Deklaracja SQL-owej instrukcji SELECT zwracającej obiekt typu CLOB.
      $stmt = "SELECT   item_desc
               FROM     item
               WHERE    item_id = :id";

      // Parsowanie zapytania z wykorzystaniem połączenia.
      $s = oci_parse($c,$stmt);

      // Wiązanie zmiennych języka PHP z typami OCI.
      oci_bind_by_name($s,':id',$id);

      // Wykonywanie instrukcji języka PL/SQL.
      if (oci_execute($s))
      {
        // Zwracanie deskryptora obiektu LOB.
        while (oci_fetch($s))
        {
          for ($i = 1;$i <= oci_num_fields($s);$i++)
            if (is_object(oci_result($s,$i)))
            {
              if ($size = oci_result($s,$i)->size())
              {
                $data = oci_result($s,$i)->read($size);
              }
              else
                $data = "&nbsp;";
            }
            else
            {
              if (oci_field_is_null($s,$i))
                $data = "&nbsp;";
              else
                $data = oci_result($s,$i);
            }

        } // Koniec pętli while(oci_fetch($s)).

        // Zwalnianie zasobów.
        oci_free_statement($s);

        // Formatowanie tabeli HTML-a w celu wyświetlenia zdjęcia (typ BLOB) i opisu (typ CLOB).
        $out = '<table border="1" cellpadding="5" cellspacing="0">';
        $out .= '<tr>';
        $out .= '<td align="center" class="e">'.$title.'</td>';
        $out .= '</tr>';
        $out .= '<tr><td class="v">';
        $out .= '<div>';
        $out .= '<div style="margin-right:5px;float:left">';
        $out .= '<img src="ConvertBlobToImage.php?id='.$id.'">';
        $out .= '</div>';
        $out .= '<div style="position=relative;">'.$data.'</div>';
        $out .= '</div>';
        $out .= '</td></tr>';
        $out .= '</table>';
      }

      // Wyświetlanie tabeli HTML-a.
      print $out;

      // Zamknięcie połączenia z bazą.
      oci_close($c);
    }
    else
    {
      // Przypisywanie błędu OCI i formatowanie apostrofów oraz cudzysłowów.
      $errorMessage = oci_error();
      print htmlentities($errorMessage['message'])."<br />";
    }
  }

  // Zarządza przesyłaniem pliku i zwraca go jako łańcuch znaków.
  function process_uploaded_file()
  {
    // Deklaracja zmiennej na zawartość pliku.
    $contents = "";

    // Definowanie nazwy pliku na potrzeby systemów Windows i Linux.
    if (ereg("Win32",$_SERVER["SERVER_SOFTWARE"]))
      $upload_file = getcwd()."\\temp\\".$_FILES['userfile']['name'];
    else
      $upload_file = getcwd()."/temp/".$_FILES['userfile']['name'];

    // Sprawdzanie, czy plik istnieje, i przenoszenie go.
    if (is_uploaded_file($_FILES['userfile']['tmp_name']))
      move_uploaded_file($_FILES['userfile']['tmp_name'],$upload_file);

    // Otwieranie uchwytu do pliku i blokowanie błędu braku pliku.
    if ($fp = @fopen($upload_file,"r"))
    {
      // Wczytywanie danych do momentu natrafienia na znacznik końca pliku.
      while (!feof($fp))
        $contents .= fgetc($fp);

      // Zamykanie otwartego uchwytu do pliku.
      fclose($fp);
    }

    // Zwracanie zawartości pliku jako łańcucha znaków.
    return $contents;
  }

  // Usuwanie znaków specjalnych (na przykład znaku nowego wiersza i tabulacji).
  function backquote_apostrophe($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if (ord($str[$i]) != 39)
        $out .= $str[$i];
      else
        $out .= "'".$str[$i];
    // Zwraca wstępnie sparsowaną instrukcję SQL-a.
    return $out;
  }

  // Usuwanie znaków specjalnych (na przykład znaku nowego wiersza i tabulacji).
  function strip_special_characters($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if ((ord($str[$i]) != 9) && (ord($str[$i]) != 10) &&
          (ord($str[$i]) != 13))
        $out .= $str[$i];

    // Zwraca wstępnie sparsowaną instrukcję SQL-a.
    return $out;
  }
?>
</body>
</html>