/* ================================================================
||   Program Name: create_package_variables.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt pokazuje, jak używać zmiennych pakietu.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE PACKAGE shared_variables IS
  protected   CONSTANT NUMBER := 1;
  unprotected          NUMBER := 1;
END shared_variables;
/

CREATE OR REPLACE PROCEDURE change_unprotected (value NUMBER) IS
  PRAGMA AUTONOMOUS_TRANSACTION;
BEGIN
  shared_variables.unprotected := shared_variables.unprotected + value;
  dbms_output.put_line('Zmienna unprotected ['||shared_variables.unprotected||']');
END change_unprotected;
/

EXECUTE change_unprotected(2);
EXECUTE change_unprotected(2);

ALTER PACKAGE shared_variables COMPILE SPECIFICATION;

EXECUTE change_unprotected(2);