/* ================================================================
||   Program Name: deterministic.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje różne funkcje deterministyczne.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED

-- Po zakończeniu debugowania umieść te instrukcje w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION pv
( future_value    NUMBER
, periods         NUMBER
, interest        NUMBER )
RETURN NUMBER DETERMINISTIC IS
BEGIN
  RETURN future_value / ((1 + interest/100)**periods);
END pv;
/

CREATE OR REPLACE FUNCTION fv
( current_value   NUMBER := 0
, periods         NUMBER := 1
, interest        NUMBER)
RETURN NUMBER DETERMINISTIC IS
BEGIN
  -- Odsetki z dzienną kapitalizacją.
  RETURN current_value * (1 + ((1 + ((interest/100)/365))**365 -1)*periods);
END fv;
/