<?php
  /* ================================================================
  ||   Program: dynamic_topnquery.php
  ||   Data:       2013-12-02
  ||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
  ||   Rozdział:   2
  ||   Autor:  Michael McLaughlin
  || ----------------------------------------------------------------
  ||   Zawartość:
  ||   ---------
  ||   Ten skrypt pokazuje, jak stosować dynamicznie określane ograniczenia jako
  ||   argumenty OFFSET i FIRST.
  ||
  ||   Wywołanie bez ograniczeń:
  ||   ====================
  ||     http://localhost/dynamic_topnquery.php
  ||
  ||   Wywołanie z ograniczeniami:
  ||   =================
  ||     http://localhost/dynamic_topnquery.php?offset=1&rows=5
  || ================================================================*/


  $title = "Item Title";

  // Próba połączenia się z bazą danych.
  $c = @oci_connect("c##plsql", "Student1", "localhost/orcl");
  if (!$c) {
    print "Niestety, próba nawiązania połączenia z bazą zakończyła się niepowodzeniem. Spróbuj ponownie później.";
    die();
  }
  else {
    // Inicjowanie komunikatu niezależnie od tego, czy parametry są podane.
    $offset = (isset($_GET['offset'])) ? $_GET['offset'] : 0;
    $rows = (isset($_GET['rows'])) ? $_GET['rows'] : 20;
 
    // Ustawianie wywołania (tak jak instrukcji SQL-a).
    $sql = "SELECT   i.item_title "
         . "FROM     item i "
         . "OFFSET :bv_offset ROWS FETCH FIRST :bv_rows ROWS ONLY";
 
    // Przygotowanie instrukcji i powiązanie dwóch łańcuchów znaków.
    $stmt = oci_parse($c,$sql);
 
    // Powiązanie zmiennych lokalnych z instrukcją PHP. TRZEBA określić wielkość zmiennych w trybie OUT.
    oci_bind_by_name($stmt, ":bv_offset", $offset);
    oci_bind_by_name($stmt, ":bv_rows", $rows);
 
    // Wykonanie instrukcji języka PL/SQL.
    if (oci_execute($stmt))
    {

      // Ustawienie znaczników tabeli i nagłówka.
      $out = '<html>';
      $out .= '<head>';
      $out .= '<style type="text/css">';
      $out .= '.e {background-color: #ccccff; font-weight: bold; color: #000000;}';
      $out .= '.h {background-color: #9999cc; font-weight: bold; color: #000000;}';
      $out .= '.v {background-color: #cccccc; color: #000000;}';
      $out .= '</style>';
      $out .= '</head>';
      $out .= '<body>';
      $out .= '<table border="1" cellpadding="3" cellspacing="0">';
      $out .= '<tr>';
      $out .= '<th align="center" class="e">'.$title.'</th>';
      $out .= '</tr>';

      // Zwracanie deskryptora obiektu LOB.
      while (oci_fetch($stmt))
      { 
        // Otwarcie wiersza.
        $out .= '<tr>';

        // Wczytanie listy kolumn.
        for ($i = 1;$i <= oci_num_fields($stmt);$i++) {
          if (is_object(oci_result($stmt,$i)))
          {
            if ($size = oci_result($stmt,$i)->size())
              $data = oci_result($stmt,$i)->read($size);
            else
              $data = "&nbsp;";
          }
          else
          {
            if (oci_field_is_null($stmt,$i))
              $data = "&nbsp;";
            else {
              $data = oci_result($stmt,$i);
            }
          }

          // Ustawienie komórki.
          $out .= '<td class="v">'.$data.'</td>';
        }
        // Zamknięcie wiersza.
        $out .= '</tr>';
      } // Koniec pętli while(oci_fetch($s)). 

      // Zamknięcie tabeli.
      $out .= '</table>';
      $out .= '</body>';
      $out .= '</html>';
    }
    else { 
      print "Niestety, nie mogę tego zrobić, Dave...";
    }

    // Zwalnianie zasobów.
    oci_free_statement($stmt);
    oci_close($c);
  }

  print $out;
?>
