/* ================================================================
||   Program: create_dbms_sql2.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie pakietu DBMS_SQL do warunkowego
||   scalania łańcuchów znaków.
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicje zmiennych lokalnych na potrzeby pakietu DBMS_SQL.
  c      INTEGER := dbms_sql.open_cursor;
  fdbk   INTEGER;
  stmt1  VARCHAR2(2000);
  stmt2  VARCHAR2(20) := '-1,SYSDATE)';

  -- Zmienna na parametr wyjściowy.
  client VARCHAR2(64);
BEGIN
  stmt1 := 'INSERT INTO item VALUES '
        || '( item_s1.nextval '
        || ',''ASIN'||CHR(58)||' B000VBJEEG'''
        || ',(SELECT   common_lookup_id '
        || '  FROM     common_lookup '
        || '  WHERE    common_lookup_type = ''DVD_WIDE_SCREEN'') '
        || ',''Ratatouille'''
        || ','''''
        || ', empty_clob() '
        || ', NULL '
        || ',''G'''
        || ',''MPAA'''
        || ',''06-NOV-2007'''
        || ', 3, SYSDATE,';

  dbms_application_info.read_client_info(client);
  IF client IS NOT NULL THEN
    stmt1 := stmt1 || client || ',SYSDATE)';
  ELSE
    stmt1 := stmt1 || stmt2;
  END IF;
           
  -- Parsowanie i wykonywanie instrukcji.
  dbms_sql.parse(c,stmt1,dbms_sql.native);
  fdbk := dbms_sql.execute(c);
  dbms_sql.close_cursor(c);
  dbms_output.put_line('Wstawione wiersze ['||fdbk||']');
END;
/

INSERT INTO item VALUES
( item_s1.nextval
,'ASIN: B000VBJEEG'
,(SELECT   common_lookup_id
  FROM     common_lookup
  WHERE    common_lookup_type = 'DVD_WIDE_SCREEN')
,'Ratatouille'
,''
, empty_clob()
, NULL
,'G'
,'MPAA'
,'06-NOV-2007'
, 3, SYSDATE, 3, SYSDATE);
