/* ================================================================
||   Program: order_compare.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   11
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Tworzy specyfikację i ciało typu obiektowego, a następnie je testuje.
|| ---------------------------------------------------------------- */

DECLARE
  -- Deklaracja kolekcji elementów typu obiektowego.
  TYPE object_list IS TABLE OF ORDER_COMP;
  
  -- Inicjowanie obiektów nieuporządkowanych alfabetycznie.
  lv_obj1 ORDER_COMP := order_comp('Ron Weasley','Harry Potter 1');
  lv_obj2 ORDER_COMP := order_comp('Harry Potter','Harry Potter 1');
  lv_obj3 ORDER_COMP := order_comp('Luna Lovegood','Harry Potter 5');
  lv_obj4 ORDER_COMP := order_comp('Hermione Granger','Harry Potter 1');
  lv_obj5 ORDER_COMP := order_comp('Hermione Granger','Harry Potter 2');
  lv_obj6 ORDER_COMP := order_comp('Harry Potter','Harry Potter 5');
  lv_obj7 ORDER_COMP := order_comp('Cedric Diggory','Harry Potter 4');
  lv_obj8 ORDER_COMP := order_comp('Severus Snape','Harry Potter 1');

  -- Definicja kolekcji obiektów.
  lv_objs OBJECT_LIST := object_list(lv_obj1,lv_obj2,lv_obj3,lv_obj4
                                    ,lv_obj5,lv_obj6,lv_obj7,lv_obj8);

  -- Przestawia A z B.
  PROCEDURE swap (a IN OUT ORDER_COMP, b IN OUT ORDER_COMP) IS
    c ORDER_COMP;
  BEGIN
    c := b;
    b := a;
    a := c;
  END swap;
  
BEGIN
  -- Sortowanie bąbelkowe.
  FOR i IN 1..lv_objs.COUNT LOOP
    FOR j IN 1..lv_objs.COUNT LOOP
      IF lv_objs(i).equals(lv_objs(j)) = 0 THEN
        swap(lv_objs(i),lv_objs(j));
      END IF;
    END LOOP;
  END LOOP;
  -- Wyświetlanie obiektów w nowej kolejności.
  FOR i IN 1..lv_objs.COUNT LOOP
    dbms_output.put_line(lv_objs(i).to_string);
  END LOOP;
END;
/
