/* ================================================================
||   Program: get_directory_path.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   10
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   UWAGI:
||  - Ten skrypt trzeba uruchomić z konta SYSTEM.
||  - Konto SYSTEM musi mieć bezpośrednio (nie poprzez rolę) przyznane uprawnienia SELECT.
||  - Konto SYSTEM domyślnie ma uprawnienia dzięki roli SELECT_CATALOG_ROLE.
||  - Uprawnienia kontu SYSTEM należy przyznać w następujący sposób:
||
||     SQL> CONNECT / as sysdba
||     Connected.
||     SQL> GRANT SELECT ON dba_directories TO system;
||     Grant succeeded.
||
|| Ten skrypt zawiera funkcję składowaną zwracającą ścieżkę do katalogu
|| powiązaną z określonym katalogiem wirtualnym bazy danych.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION get_directory_path
( virtual_directory IN VARCHAR2 )
RETURN VARCHAR2 IS

  -- Definicja zwracanej zmiennej.
  directory_path VARCHAR2(256) := 'C:\';

  -- Definicja kursora dynamicznego.
  CURSOR get_directory (virtual_directory VARCHAR2) IS
    SELECT   directory_path
    FROM     sys.dba_directories
    WHERE    directory_name = virtual_directory;

  -- Definicja lokalnego wyjątku związanego ze złą nazwą.
  directory_name EXCEPTION;
  PRAGMA EXCEPTION_INIT(directory_name,-22284);  

BEGIN

  OPEN  get_directory (virtual_directory);
  FETCH get_directory
  INTO  directory_path;
  CLOSE get_directory;

  -- Zwracanie ścieżki.
  RETURN directory_path;

EXCEPTION
  WHEN directory_name THEN
  RETURN NULL;

END get_directory_path;
/

show errors

GRANT EXECUTE ON get_directory_path TO php;

GRANT CREATE ANY SYNONYM TO php;

CONNECT php/php

CREATE SYNONYM get_directory_path FOR system.get_directory_path;
