<html>
<! ================================================================>
<!   Program: QueryRelativeBFILE.php                               >
<!   Data:      2013-07-25                                         >
<!   Książka:   Oracle Database 12c. Programowanie w języku PL/SQL >
<!   Rozdział:  10                                                 >
<!   Autor:  Michael McLaughlin                                    >
<! ---------------------------------------------------------------->
<!   Zawartość:                                                    >
<!   ---------                                                     >
<!   Ten skrypt ilustruje przesyłanie pliku, przenoszenie          >
<!   przesłanego pliku, zapisywanie danych w kolumnie typu CLOB    >
<!   za pomocą procedury składowanej języka PL/SQL, dostęp do      >
<!   danych zapisanych w bazie i wyświetlanie strony.              >
<head>
<title>
  Rozdział 10. QueryRelativeBFILE.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Deklaracja zmiennych wejściowych.
  (isset($_GET['id']))    ? $id = (int) $_GET['id'] : $id = 1021;

  // Wywołanie funkcji lokalnej.
  query_insert($id);

  // Pobieranie wyników po wstawieniu danych.
  function query_insert($id)
  {
    // Próba nawiązania połączenia z bazą danych.
    if ($c = @oci_connect("plsql","plsql","orcl"))
    {
      // Deklaracja SQL-owej instrukcji SELECT zwracającej obiekt typu CLOB.
      $stmt = "SELECT   item_title
               ,        item_desc
               ,        get_bfilename('ITEM','ITEM_PHOTO','ITEM_ID',:id)
               FROM     item
               WHERE    item_id = :id";

      // Parsowanie zapytania z wykorzystaniem połączenia.
      $s = oci_parse($c,$stmt);

      // Wiązanie zmiennych PHP z typami OCI.
      oci_bind_by_name($s,':id',$id);

      // Wykonywanie instrukcji języka PL/SQL.
      if (oci_execute($s))
      {
        // Zwracanie deskryptora typu LOB.
        while (oci_fetch($s))
        {
          for ($i = 1;$i <= oci_num_fields($s);$i++)
            if (is_object(oci_result($s,$i)))
            {
              if ($size = oci_result($s,$i)->size())
                if (oci_field_type($s,$i) == 'CLOB')
                  $data = oci_result($s,$i)->read($size);
              else
                $data = "&nbsp;";
            }
            else
            {
              if (oci_field_is_null($s,$i))
                $title = "&nbsp;";
              else
                if (substr(oci_result($s,$i),0,1) == '/')
                  $photo = oci_result($s,$i);
                else
                  $title = oci_result($s,$i);
            }

        } // Koniec pętli while(oci_fetch($s)).

        // Zwalnianie zasobów.
        oci_free_statement($s);

        // Formatowanie tabeli HTML-a wyświetlającej zdjęcie (typ BLOB) i opis (typ CLOB).
        $out = '<table border="1" cellpadding="5" cellspacing="0">';
        $out .= '<tr>';
        $out .= '<td align="center" class="e">'.$title.'</td>';
        $out .= '</tr>';
        $out .= '<tr><td class="v">';
        $out .= '<div>';
        $out .= '<div style="margin-right:5px;float:left">';
        $out .= '<img src="'.$photo.'">';
        $out .= '</div>';
        $out .= '<div style="position=relative;">'.$data.'</div>';
        $out .= '</div>';
        $out .= '</td></tr>';
        $out .= '</table>';
      }

      // Wyświetlanie tabeli HTML-a.
      print $out;

      // Zamykanie połączenia z bazą.
      oci_close($c);
    }
    else
    {
      // Przypisywanie błędu OCI i formatowanie apostrofów oraz cudzysłowów.
      $errorMessage = oci_error();
      print htmlentities($errorMessage['message'])."<br />";
    }
  }
?>
</body>
</html>