/* ================================================================
||   Program: exception_handling.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   7
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt zawiera krótkie programy związane z typami wyjątków,
||   funkcjami wbudowanymi i wyjątkami zdefiniowanymi przez użytkownika.
|| ================================================================*/

DECLARE
  lv_a VARCHAR2(1);
  lv_b VARCHAR2(2) := 'AB';
BEGIN
  lv_a := lv_b;
EXCEPTION
  WHEN value_error THEN
    dbms_output.put_line(
      'Nie można umieścić ['||lv_b||'] w jednoznakowym łańcuchu.');
END;
/

DECLARE
  lv_a  VARCHAR2(1);
BEGIN
  DECLARE
    lv_b VARCHAR2(2);
  BEGIN
    SELECT 1 INTO lv_b
    FROM dual
    WHERE 1 = 2;
    lv_a := lv_b;
  EXCEPTION
    WHEN value_error THEN
      dbms_output.put_line(
       'Nie można umieścić ['||lv_b||'] w jednoznakowym łańcuchu.');
  END;
EXCEPTION
  WHEN others THEN
    dbms_output.put_line(
      'Przechwycony w bloku zewnętrznym ['||SQLERRM||'].');
END;
/

DECLARE
  lv_a  VARCHAR2(1);
  e     EXCEPTION;
BEGIN
  DECLARE
    lv_b VARCHAR2(2) := 'AB';
  BEGIN
    RAISE e;
  EXCEPTION
    WHEN others THEN
      lv_a := lv_b;
      dbms_output.put_line('Nigdy nie dochodzi do tego miejsca.');
  END;
EXCEPTION
  WHEN others THEN
    dbms_output.put_line(
      'Przechwycony w bloku zewnętrznym->'||dbms_utility.format_error_backtrace);
END;
/

DECLARE
  lv_a CHAR := '&input';
BEGIN
  dbms_output.put_line('['||lv_a||']');
EXCEPTION
  WHEN OTHERS THEN
    dbms_output.put_line('['||SQLERRM||']'
END;
/

BEGIN
  DECLARE
    lv_a CHAR := '&input';
  BEGIN
    dbms_output.put_line('['||lv_a||']');
  END;
EXCEPTION
  WHEN OTHERS THEN
    dbms_output.put_line('['||SQLERRM||']');
END;
/

CREATE OR REPLACE FUNCTION runtime_error
(lv_input  VARCHAR2) RETURN VARCHAR2 IS
  a VARCHAR2(1) := lv_input;
BEGIN
  NULL;
EXCEPTION
  WHEN others THEN
    dbms_output.put_line('Błąd w funkcji.');
END;
/

SELECT runtime_error ('AB') FROM dual;

DECLARE
  e EXCEPTION;
BEGIN
  RAISE e;
  dbms_output.put_line('Nigdy nie dochodzi do tego miejsca.');
EXCEPTION
  WHEN OTHERS THEN  /* Przechwytuje wszystkie wyjątki. */
    /* Wykrywanie wyjątku zdefiniowanego przez użytkownika. */
    IF SQLCODE = 1 THEN
      dbms_output.put_line('To wyjątek ['||SQLERRM||'].');
    END IF;
END;
/

DECLARE
  lv_a VARCHAR2(20);
  invalid_userenv_parameter EXCEPTION;
  PRAGMA EXCEPTION_INIT(invalid_userenv_parameter,-2003);
BEGIN
  lv_a := SYS_CONTEXT('USERENV','PROXY_PUSHER');
EXCEPTION
  WHEN invalid_userenv_parameter THEN
    dbms_output.put_line(SQLERRM);
END;
/

DECLARE
  e  EXCEPTION;
  PRAGMA EXCEPTION_INIT(e,-20001);
BEGIN
  RAISE e;
EXCEPTION
  WHEN e THEN
  dbms_output.put_line(SQLERRM);
END;
/

BEGIN
  RAISE_APPLICATION_ERROR(-20001,'Niezbyt oryginalny komunikat.');
EXCEPTION
  WHEN others THEN
    dbms_output.put_line(SQLERRM);
END;
/

DECLARE
   e EXCEPTION;
  PRAGMA EXCEPTION_INIT(e,-20001);
BEGIN
  RAISE_APPLICATION_ERROR(-20001,'Niezbyt oryginalny komunikat.');
EXCEPTION
  WHEN e THEN
    dbms_output.put_line(SQLERRM);
END;
/

DECLARE
  lv_a         VARCHAR2(1);
  lv_b VARCHAR2(2) := 'AB';
BEGIN
  lv_a := lv_b;
  dbms_output.put_line('Nigdy nie dochodzi do tego wiersza.');
EXCEPTION
  WHEN value_error THEN
    RAISE_APPLICATION_ERROR(-20001,'Określony komunikat.');
  WHEN others THEN
    dbms_output.put_line(SQLERRM);
END;
/