SELECT * FROM table (DBMS_XPLAN.DISPLAY_CURSOR('0rc4km05kgzb9', NULL, 'ADAPTIVE'));

DECLARE
  tune_sql CLOB;
  tune_task VARCHAR2(30);
BEGIN
  tune_sql := 'select count(*) from emp';
  tune_task := DBMS_SQLTUNE.CREATE_TUNING_TASK(
    sql_text => tune_sql,
    user_name => 'SERWIS',
    scope => 'COMPREHENSIVE',
    time_limit => 60,
    task_name => 'REGULACJA1',
    description => 'Zastosowanie SQL Tuning Advisor dla jednego zapytania'
  );
END;
/

@sqltune.sql

exec dbms_sqltune.execute_tuning_task(task_name=>'REGULACJA1');

set long 10000
set longchunksize 10000
set lines 132
set pages 200
select dbms_sqltune.report_tuning_task('REGULACJA1') from dual;

begin
-- This is the code from the SQL Tuning Advisor
dbms_sqltune.accept_sql_profile(
    task_name => 'REGULACJA1',
    task_owner => 'SYS',
    replace => TRUE,
    profile_type => DBMS_SQLTUNE.PX_PROFILE);
--
end;
/

exec DBMS_SQLTUNE.DROP_TUNING_TASK(task_name=>'REGULACJA1');

SELECT DBMS_AUTO_SQLTUNE.REPORT_AUTO_TUNING_TASK FROM DUAL;

select value from my_table where value = 'AA';
select value from my_table where value = 'bb';
