create table dzienna_sprzedaz
(produkt_id number not null
, klient_id number not null
, data_sprzedazy date not null
, liczba_sprzedanych number(3) not null
, cena_jednostkowa number(10,2) not null
, cena_calkowita_sprzedazy number(10,2) not null
, rabat_calkowity number(10,2) not null)
partition by range(data_sprzedazy)
interval (numtoyminterval(1,'MONTH'))
(partition p_przed_1_sty_2007 values
less than (to_date('01-01-2007','dd-mm-yyyy')));


create table dzienna_sprzedaz_2
(produkt_id number not null
, klient_id varchar2(2) not null
, data_sprzedazy date not null
, liczba_sprzedanych number(3) not null
, data_dostawy date not null
, cena_jednostkowa number(10,2) not null
, cena_calkowita_sprzedazy number(10,2) not null
, rabat_calkowity number(10,2) not null)
partition by range(data_sprzedazy)
interval (numtoyminterval(1, 'MONTH')) store in (tbs_1, tbs_2)
subpartition by list(klient_id)
(partition p_przed_1_sty_2007 values
less than (to_date('01-01-2007','dd-mm-yyyy'))
(subpartition sub_zero_trzy values ('AA','AB','AC','AD'),
subpartition sub_cztery_siedem values ('AE','AF','AG','AH')));


create table informacje_o_sprzedazy
(numer_klienta number, numer_produktu number, liczba_sprzedanych number,
data_sprzedazy date, data_dostawy date)
partition by range (data_sprzedazy)
subpartition by range (data_dostawy)
(partition sprzedane_przed_01_07
values less than(to_date('01-01-2007','mm-dd-yyyy') )
(subpartition sprzedane_p_01_07_dost_p_01_07
values less than(to_date('01-01-2007','mm-dd-yyyy') ),
subpartition sprzedane_p_01_07_dost_01_07
values less than(to_date('02-01-2007','mm-dd-yyyy') ),
subpartition sprzedane_p_01_07_dost_02_07
values less than(to_date('03-01-2007','mm-dd-yyyy'))),
partition sprzedane_01_07
values less than(to_date('02-01-2007','mm-dd-yyyy') )
(subpartition sprzedane_01_07_dost_01_07
values less than(to_date('02-01-2007','mm-dd-yyyy') ),
subpartition sprzedane_01_07_dost_02_07
values less than(to_date('03-01-2007','mm-dd-yyyy'))) );


create table zamowienia_klientow
(klient_id number, zamowienie_id number not null,
data_zamowienia date not null, tryb_zamowienia varchar2(8),
status_zamowienia varchar2(1))
partition by range (data_zamowienia)
(partition p_przed_sty_2007
values less than(to_date('01-STY-2007','dd-MON-yyyy'))
, partition p_sty_2007
values less than(to_date('01-LUT-2007','dd-MON-yyyy')))
parallel;
alter table zamowienia_klientow
add constraint zamowienia_klientow_pk
primary key(zamowienie_id);


create table zamowione_produkty
(zamowienie_id number not null
, produkt_id number not null
, liczba number not null
, kwota_sprzedazy number not null
, constraint zam_prod_zam_kl_fk
foreign key (zamowienie_id) references zamowienia_klientow(zamowienie_id) )
partition by reference (zam_prod_zam_kl_fk)
parallel;


create table part_pracownicy
(prac_id number primary key,
pensja number (8,2) not null,
lata_pracy number not null,
obecny_d_emerytalny as (pensja*.0005*lata_pracy) )
partition by range (obecny_d_emerytalny)
(partition niewiele values less than (100)
,partition w_sam_raz values less than (500)
,partition o_nie_mamy_klopoty values less than (maxvalue));
