-- Tworzymy przykładową tabelę
CREATE table sprzedaz_kwartalna
(miesiac_sprzedazy number,
sprzedawca_id number,
data_sprzedazy date,
klient_id number,
liczba_sprzedanych number,
kwota_sprzedazy number)
    PARTITION BY list (miesiac_sprzedazy) (
    PARTITION kw_pierwszy values (1, 2, 3),
    PARTITION kw_drugi values (4, 5, 6),
    PARTITION kw_trzeci values (7, 8, 9),
    PARTITION kw_czwarty values (10, 11, 12),
    PARTITION inne values (default));


-- Tworzymy dziennik widoku zmaterializowanego
CREATE MATERIALIZED VIEW LOG
ON sprzedaz_kwartalna WITH ROWID(miesiac_sprzedazy)
INCLUDING NEW VALUES;


-- Tworzymy widok zmaterializowany
DROP MATERIALIZED VIEW mv_sprzedaz_sum;
CREATE MATERIALIZED VIEW mv_sprzedaz_sum
    BUILD IMMEDIATE
    REFRESH FAST ON DEMAND
    ENABLE QUERY REWRITE
AS
SELECT klient_id, miesiac_sprzedazy, SUM(liczba_sprzedanych) AS calk_licz_sprzed
    ,COUNT(liczba_sprzedanych) AS cnt_licz_sprzed
    ,SUM(kwota_sprzedazy) AS calk_kw_sprzed
    ,COUNT(kwota_sprzedazy) AS cnt_kw_sprzed
FROM sprzedaz_kwartalna
GROUP BY klient_id, miesiac_sprzedazy;
